/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.replicator.command.SafeTimeSyncCommand;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.table.distributed.command.FinishTxCommand;
import org.apache.ignite.internal.table.distributed.command.TxCleanupCommand;
import org.apache.ignite.internal.table.distributed.command.UpdateAllCommand;
import org.apache.ignite.internal.table.distributed.command.UpdateCommand;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.ReadCommand;
import org.apache.ignite.raft.client.WriteCommand;
import org.apache.ignite.raft.client.service.CommandClosure;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PartitionListener
implements RaftGroupListener {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionListener.class);
    private final MvPartitionStorage storage;
    private final TxStateStorage txStateStorage;
    private final TxManager txManager;
    private final Supplier<Map<UUID, TableSchemaAwareIndexStorage>> indexes;
    private final HashMap<UUID, Set<RowId>> txsPendingRowIds = new HashMap();

    public PartitionListener(MvPartitionStorage store, TxStateStorage txStateStorage, TxManager txManager, Supplier<Map<UUID, TableSchemaAwareIndexStorage>> indexes) {
        this.storage = store;
        this.txStateStorage = txStateStorage;
        this.txManager = txManager;
        this.indexes = indexes;
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            assert (false) : "No read commands expected, [cmd=" + command + "]";
        });
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        iterator.forEachRemaining(clo -> {
            Command command = clo.command();
            long commandIndex = clo.index();
            long storageAppliedIndex = this.storage.lastAppliedIndex();
            assert (storageAppliedIndex < commandIndex) : "Pending write command has a higher index than already processed commands [commandIndex=" + commandIndex + ", storageAppliedIndex=" + storageAppliedIndex + "]";
            try {
                if (command instanceof UpdateCommand) {
                    this.handleUpdateCommand((UpdateCommand)command, commandIndex);
                } else if (command instanceof UpdateAllCommand) {
                    this.handleUpdateAllCommand((UpdateAllCommand)command, commandIndex);
                } else if (command instanceof FinishTxCommand) {
                    this.handleFinishTxCommand((FinishTxCommand)command, commandIndex);
                } else if (command instanceof TxCleanupCommand) {
                    this.handleTxCleanupCommand((TxCleanupCommand)command, commandIndex);
                } else if (command instanceof SafeTimeSyncCommand) {
                    this.handleSafeTimeSyncCommand((SafeTimeSyncCommand)command);
                } else assert (false) : "Command was not found [cmd=" + command + "]";
                clo.result(null);
            }
            catch (IgniteInternalException e) {
                clo.result((Serializable)((Object)e));
            }
        });
    }

    private void handleUpdateCommand(UpdateCommand cmd, long commandIndex) {
        this.storage.runConsistently(() -> {
            BinaryRow row = cmd.getRow();
            RowId rowId = cmd.getRowId();
            UUID txId = cmd.txId();
            UUID commitTblId = cmd.getCommitReplicationGroupId().getTableId();
            int commitPartId = cmd.getCommitReplicationGroupId().getPartId();
            this.storage.addWrite(rowId, row, txId, commitTblId, commitPartId);
            this.txsPendingRowIds.computeIfAbsent(txId, entry -> new HashSet()).add(rowId);
            this.addToIndexes(row, rowId);
            this.storage.lastAppliedIndex(commandIndex);
            return null;
        });
    }

    private void handleUpdateAllCommand(UpdateAllCommand cmd, long commandIndex) {
        this.storage.runConsistently(() -> {
            UUID txId = cmd.txId();
            HashMap<RowId, BinaryRow> rowsToUpdate = cmd.getRowsToUpdate();
            UUID commitTblId = cmd.getReplicationGroupId().getTableId();
            int commitPartId = cmd.getReplicationGroupId().getPartId();
            if (!CollectionUtils.nullOrEmpty(rowsToUpdate)) {
                for (Map.Entry entry : rowsToUpdate.entrySet()) {
                    RowId rowId = (RowId)entry.getKey();
                    BinaryRow row = (BinaryRow)entry.getValue();
                    this.storage.addWrite(rowId, row, txId, commitTblId, commitPartId);
                    this.txsPendingRowIds.computeIfAbsent(txId, entry0 -> new HashSet()).add(rowId);
                    this.addToIndexes(row, rowId);
                }
            }
            this.storage.lastAppliedIndex(commandIndex);
            return null;
        });
    }

    private void handleFinishTxCommand(FinishTxCommand cmd, long commandIndex) throws IgniteInternalException {
        UUID txId = cmd.txId();
        TxState stateToSet = cmd.commit() ? TxState.COMMITED : TxState.ABORTED;
        TxMeta txMetaToSet = new TxMeta(stateToSet, cmd.replicationGroupIds(), cmd.commitTimestamp());
        TxMeta txMetaBeforeCas = this.txStateStorage.get(txId);
        boolean txStateChangeRes = this.txStateStorage.compareAndSet(txId, null, txMetaToSet, commandIndex);
        LOG.debug("Finish the transaction txId = {}, state = {}, txStateChangeRes = {}", new Object[]{txId, txMetaToSet, txStateChangeRes});
        if (!txStateChangeRes) {
            UUID traceId = UUID.randomUUID();
            String errorMsg = IgniteStringFormatter.format((String)"Fail to finish the transaction txId = {} because of inconsistent state = {}, expected state = null, state to set = {}", (Object[])new Object[]{txId, txMetaBeforeCas, txMetaToSet});
            IgniteInternalException stateChangeException = new IgniteInternalException(traceId, ErrorGroups.Transactions.TX_UNEXPECTED_STATE_ERR, errorMsg);
            LOG.error(errorMsg, new Object[0]);
            throw stateChangeException;
        }
    }

    private void handleTxCleanupCommand(TxCleanupCommand cmd, long commandIndex) {
        this.storage.runConsistently(() -> {
            UUID txId = cmd.txId();
            Set<RowId> pendingRowIds = this.txsPendingRowIds.getOrDefault(txId, Collections.emptySet());
            if (cmd.commit()) {
                pendingRowIds.forEach(rowId -> this.storage.commitWrite(rowId, cmd.commitTimestamp()));
            } else {
                pendingRowIds.forEach(arg_0 -> ((MvPartitionStorage)this.storage).abortWrite(arg_0));
            }
            this.txsPendingRowIds.remove(txId);
            this.txManager.changeState(txId, null, cmd.commit() ? TxState.COMMITED : TxState.ABORTED);
            this.storage.lastAppliedIndex(commandIndex);
            return null;
        });
    }

    private void handleSafeTimeSyncCommand(SafeTimeSyncCommand cmd) {
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        this.storage.flush();
    }

    public boolean onSnapshotLoad(Path path) {
        return true;
    }

    public void onShutdown() {
        try {
            this.storage.close();
        }
        catch (Exception e) {
            throw new IgniteInternalException("Failed to close storage: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addToIndexes(@Nullable BinaryRow tableRow, RowId rowId) {
        if (tableRow == null || !tableRow.hasValue()) {
            return;
        }
        for (TableSchemaAwareIndexStorage index : this.indexes.get().values()) {
            index.put(tableRow, rowId);
        }
    }

    @TestOnly
    public MvPartitionStorage getStorage() {
        return this.storage;
    }
}

