/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.exec.ExecutionCancelledException;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.sql.CursorClosedException;
import org.jetbrains.annotations.Nullable;

public class AsyncRootNode<InRowT, OutRowT>
implements Downstream<InRowT>,
AsyncCursor<OutRowT> {
    private final CompletableFuture<Void> cancelFut = new CompletableFuture();
    private final Object lock = new Object();
    private final AtomicReference<Throwable> ex = new AtomicReference();
    private final AbstractNode<InRowT> source;
    private final Function<InRowT, OutRowT> converter;
    private final AtomicBoolean taskScheduled = new AtomicBoolean();
    private final Queue<PendingRequest<OutRowT>> pendingRequests = new LinkedBlockingQueue<PendingRequest<OutRowT>>();
    private volatile boolean closed = false;
    private int waiting;
    @Nullable
    private OutRowT lastRow;
    private boolean firstRequest = true;

    public AsyncRootNode(AbstractNode<InRowT> source, Function<InRowT, OutRowT> converter) {
        this.source = source;
        this.converter = converter;
    }

    @Override
    public void push(InRowT row) throws Exception {
        assert (this.waiting > 0);
        --this.waiting;
        PendingRequest<OutRowT> currentReq = this.pendingRequests.peek();
        assert (currentReq != null);
        if (currentReq.buff.size() < currentReq.requested) {
            currentReq.buff.add(this.converter.apply(row));
        } else {
            assert (this.waiting == 0);
            this.lastRow = this.converter.apply(row);
            this.flush();
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0);
        this.waiting = -1;
        PendingRequest<OutRowT> currentReq = this.pendingRequests.peek();
        assert (currentReq != null);
        if (currentReq.buff.size() < currentReq.requested && this.lastRow != null) {
            currentReq.buff.add(this.lastRow);
            this.lastRow = null;
        }
        this.flush();
    }

    @Override
    public void onError(Throwable e) {
        if (this.closed) {
            return;
        }
        if (!this.ex.compareAndSet(null, e)) {
            this.ex.get().addSuppressed(e);
        }
        this.closeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> requestNextAsync(int rows) {
        CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> next = new CompletableFuture<AsyncCursor.BatchedResult<OutRowT>>();
        Throwable t = this.ex.get();
        if (t != null) {
            next.completeExceptionally(t);
            return next;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                next.completeExceptionally((Throwable)new CursorClosedException());
                return next;
            }
            this.pendingRequests.add(new PendingRequest<OutRowT>(rows, next));
            this.scheduleTask();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> closeAsync() {
        if (!this.closed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    Object th = this.ex.get();
                    if (th == null) {
                        th = new ExecutionCancelledException();
                    }
                    Throwable th0 = th;
                    this.pendingRequests.forEach(req -> req.fut.completeExceptionally(th0));
                    this.pendingRequests.clear();
                    this.source.context().execute(() -> {
                        try {
                            this.source.close();
                            this.source.context().cancel();
                            this.cancelFut.complete(null);
                        }
                        catch (Throwable t) {
                            this.cancelFut.completeExceptionally(t);
                            throw t;
                        }
                    }, this.source::onError);
                    this.closed = true;
                }
            }
        }
        return this.cancelFut.thenApply(Function.identity());
    }

    private void flush() {
        boolean hasMoreRow;
        PendingRequest<OutRowT> currentReq = this.pendingRequests.remove();
        assert (currentReq != null);
        this.taskScheduled.set(false);
        currentReq.fut.complete(new AsyncCursor.BatchedResult(currentReq.buff, this.waiting != -1 || this.lastRow != null));
        boolean bl = hasMoreRow = this.waiting != -1 || this.lastRow != null;
        if (hasMoreRow) {
            this.scheduleTask();
        } else {
            this.closeAsync();
        }
    }

    private void scheduleTask() {
        if (!this.pendingRequests.isEmpty() && this.taskScheduled.compareAndSet(false, true)) {
            PendingRequest<OutRowT> nextTask = this.pendingRequests.peek();
            assert (nextTask != null);
            this.source.context().execute(() -> {
                if (this.firstRequest) {
                    this.waiting = nextTask.requested + 1;
                    this.firstRequest = false;
                } else {
                    this.waiting = nextTask.requested;
                    assert (this.lastRow != null);
                    nextTask.buff.add(this.lastRow);
                    this.lastRow = null;
                }
                this.source.request(this.waiting);
            }, this.source::onError);
        }
    }

    private static class PendingRequest<OutRowT> {
        private final CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> fut;
        private final int requested;
        private final List<OutRowT> buff;

        public PendingRequest(int requested, CompletableFuture<AsyncCursor.BatchedResult<OutRowT>> fut) {
            this.requested = requested;
            this.fut = fut;
            this.buff = new ArrayList<OutRowT>(requested);
        }
    }
}

