/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDescriptor {
    private final int ver;
    private final Columns keyCols;
    private final Columns valCols;
    private final Column[] colocationCols;
    private final Map<String, Column> colMap;
    private ColumnMapper colMapper = ColumnMapping.identityMapping();

    public SchemaDescriptor(int ver, Column[] keyCols, Column[] valCols) {
        this(ver, keyCols, null, valCols);
    }

    public SchemaDescriptor(int ver, Column[] keyCols, @Nullable String[] colocationCols, Column[] valCols) {
        assert (keyCols.length > 0) : "No key columns are configured.";
        this.ver = ver;
        this.keyCols = new Columns(0, keyCols);
        this.valCols = new Columns(keyCols.length, valCols);
        assert (this.keyCols.nullMapSize() == 0) : "Primary key cannot contain nullable column [cols=" + this.keyCols + "]";
        this.colMap = new LinkedHashMap<String, Column>(keyCols.length + valCols.length);
        Stream.concat(Arrays.stream(this.keyCols.columns()), Arrays.stream(this.valCols.columns())).sorted(Comparator.comparingInt(Column::columnOrder)).forEach(c -> this.colMap.put(c.name(), (Column)c));
        this.colocationCols = ArrayUtils.nullOrEmpty((Object[])colocationCols) ? this.keyCols.columns() : (Column[])Arrays.stream(colocationCols).map(this.colMap::get).toArray(Column[]::new);
    }

    public int version() {
        return this.ver;
    }

    public boolean isKeyColumn(int idx) {
        this.validateColumnIndex(idx);
        return idx < this.keyCols.length();
    }

    public Column column(int colIdx) {
        this.validateColumnIndex(colIdx);
        return colIdx < this.keyCols.length() ? this.keyCols.column(colIdx) : this.valCols.column(colIdx - this.keyCols.length());
    }

    @Nullable
    public Column column(@NotNull String name) {
        return this.colMap.get(name);
    }

    public void validateColumnIndex(int colIdx) {
        Objects.checkIndex(colIdx, this.length());
    }

    public Collection<String> columnNames() {
        return this.colMap.keySet();
    }

    public Columns keyColumns() {
        return this.keyCols;
    }

    public Column[] colocationColumns() {
        return this.colocationCols;
    }

    public Columns valueColumns() {
        return this.valCols;
    }

    public int length() {
        return this.keyCols.length() + this.valCols.length();
    }

    public void columnMapping(ColumnMapper colMapper) {
        this.colMapper = colMapper;
    }

    public ColumnMapper columnMapping() {
        return this.colMapper;
    }

    public String toString() {
        return S.toString(SchemaDescriptor.class, (Object)this);
    }
}

