/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIoHeader;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.PageAllocationListener;
import org.apache.ignite.internal.pagememory.persistence.store.PageStore;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class FilePageStore
implements PageStore {
    private static final VarHandle PAGE_COUNT;
    private static final VarHandle NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE;
    public static final int VERSION_1 = 1;
    public static final int DELTA_FILE_VERSION_1 = 1;
    public static final int LATEST_FILE_PAGE_STORE_VERSION = 1;
    public static final int LATEST_DELTA_FILE_PAGE_STORE_VERSION = 1;
    private final FilePageStoreIo filePageStoreIo;
    private volatile int pageCount;
    @Nullable
    private volatile PageAllocationListener pageAllocationListener;
    private final List<DeltaFilePageStoreIo> deltaFilePageStoreIos;
    @Nullable
    private volatile CompletableFuture<DeltaFilePageStoreIo> newDeltaFilePageStoreIoFuture;

    public FilePageStore(FilePageStoreIo filePageStoreIo, DeltaFilePageStoreIo ... deltaFilePageStoreIos) {
        if (deltaFilePageStoreIos.length > 0) {
            Arrays.sort(deltaFilePageStoreIos, Comparator.comparingInt(DeltaFilePageStoreIo::fileIndex).reversed());
        }
        this.filePageStoreIo = filePageStoreIo;
        this.deltaFilePageStoreIos = new CopyOnWriteArrayList<DeltaFilePageStoreIo>(Arrays.asList(deltaFilePageStoreIos));
    }

    @Override
    public void stop(boolean clean) throws IgniteInternalCheckedException {
        this.filePageStoreIo.stop(clean);
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            deltaFilePageStoreIo.stop(clean);
        }
    }

    @Override
    public int allocatePage() throws IgniteInternalCheckedException {
        this.ensure();
        int pageIdx = PAGE_COUNT.getAndAdd(this, 1);
        PageAllocationListener listener = this.pageAllocationListener;
        if (listener != null) {
            listener.onPageAllocated(pageIdx);
        }
        return pageIdx;
    }

    @Override
    public int pages() {
        return this.pageCount;
    }

    public void pages(int pageCount) {
        assert (pageCount >= 0) : pageCount;
        this.pageCount = pageCount;
    }

    public void readWithoutPageIdCheck(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            long pageOff = deltaFilePageStoreIo.pageOffset(pageId);
            if (pageOff < 0L || !deltaFilePageStoreIo.readWithMergedToFilePageStoreCheck(pageId, pageOff, pageBuf, keepCrc)) continue;
            return;
        }
        this.filePageStoreIo.read(pageId, this.filePageStoreIo.pageOffset(pageId), pageBuf, keepCrc);
    }

    @Override
    public void read(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        assert (PageIdUtils.pageIndex(pageId) <= this.pageCount) : "pageIdx=" + PageIdUtils.pageIndex(pageId) + ", pageCount=" + this.pageCount;
        this.readWithoutPageIdCheck(pageId, pageBuf, keepCrc);
    }

    @Override
    public void write(long pageId, ByteBuffer pageBuf, boolean calculateCrc) throws IgniteInternalCheckedException {
        assert (PageIdUtils.pageIndex(pageId) <= this.pageCount) : "pageIdx=" + PageIdUtils.pageIndex(pageId) + ", pageCount=" + this.pageCount;
        this.filePageStoreIo.write(pageId, pageBuf, calculateCrc);
    }

    @Override
    public void sync() throws IgniteInternalCheckedException {
        this.filePageStoreIo.sync();
    }

    @Override
    public boolean exists() {
        return this.filePageStoreIo.exists();
    }

    @Override
    public void ensure() throws IgniteInternalCheckedException {
        this.filePageStoreIo.ensure();
    }

    @Override
    public void close() throws IOException {
        this.filePageStoreIo.close();
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            deltaFilePageStoreIo.close();
        }
    }

    public long size() throws IgniteInternalCheckedException {
        return this.filePageStoreIo.size();
    }

    public Path filePath() {
        return this.filePageStoreIo.filePath();
    }

    public int headerSize() {
        return this.filePageStoreIo.headerSize();
    }

    public void setPageAllocationListener(PageAllocationListener listener) {
        this.pageAllocationListener = listener;
    }

    public CompletableFuture<DeltaFilePageStoreIo> getOrCreateNewDeltaFile(IntFunction<Path> deltaFilPathFunction, Supplier<int[]> pageIndexesSupplier) {
        CompletableFuture<DeltaFilePageStoreIo> future = this.newDeltaFilePageStoreIoFuture;
        if (future != null) {
            return future;
        }
        future = new CompletableFuture();
        if (!NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE.compareAndSet(this, null, future)) {
            return this.newDeltaFilePageStoreIoFuture;
        }
        int nextIndex = this.deltaFilePageStoreIos.isEmpty() ? 0 : this.deltaFilePageStoreIos.get(0).fileIndex() + 1;
        DeltaFilePageStoreIoHeader header = new DeltaFilePageStoreIoHeader(1, nextIndex, this.filePageStoreIo.pageSize(), pageIndexesSupplier.get());
        DeltaFilePageStoreIo deltaFilePageStoreIo = new DeltaFilePageStoreIo(this.filePageStoreIo.ioFactory, deltaFilPathFunction.apply(nextIndex), header);
        this.deltaFilePageStoreIos.add(0, deltaFilePageStoreIo);
        future.complete(deltaFilePageStoreIo);
        return future;
    }

    @Nullable
    public CompletableFuture<DeltaFilePageStoreIo> getNewDeltaFile() {
        return this.newDeltaFilePageStoreIoFuture;
    }

    public void completeNewDeltaFile() {
        CompletableFuture<DeltaFilePageStoreIo> future = this.newDeltaFilePageStoreIoFuture;
        if (future == null) {
            return;
        }
        NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE.compareAndSet(this, future, null);
    }

    public int deltaFileCount() {
        return this.deltaFilePageStoreIos.size();
    }

    @Nullable
    public DeltaFilePageStoreIo getDeltaFileToCompaction() {
        Iterator<DeltaFilePageStoreIo> iterator = this.deltaFilePageStoreIos.iterator();
        DeltaFilePageStoreIo last = null;
        int count = 0;
        while (iterator.hasNext()) {
            last = iterator.next();
            ++count;
        }
        if (count == 1 && this.newDeltaFilePageStoreIoFuture != null) {
            last = null;
        }
        return last;
    }

    public boolean removeDeltaFile(DeltaFilePageStoreIo deltaFilePageStoreIo) {
        return this.deltaFilePageStoreIos.remove(deltaFilePageStoreIo);
    }

    static {
        try {
            PAGE_COUNT = MethodHandles.lookup().findVarHandle(FilePageStore.class, "pageCount", Integer.TYPE);
            NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE = MethodHandles.lookup().findVarHandle(FilePageStore.class, "newDeltaFilePageStoreIoFuture", CompletableFuture.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

