/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.jetbrains.annotations.Nullable;

public class ReadResult {
    public static final int UNDEFINED_COMMIT_PARTITION_ID = -1;
    public static final ReadResult EMPTY = new ReadResult(null, null, null, null, null, -1);
    @Nullable
    private final BinaryRow binaryRow;
    @Nullable
    private final UUID transactionId;
    @Nullable
    private final UUID commitTableId;
    private final int commitPartitionId;
    @Nullable
    private final HybridTimestamp commitTs;
    @Nullable
    private final HybridTimestamp newestCommitTs;

    private ReadResult(@Nullable BinaryRow binaryRow, @Nullable UUID transactionId, @Nullable UUID commitTableId, @Nullable HybridTimestamp commitTs, @Nullable HybridTimestamp newestCommitTs, int commitPartitionId) {
        this.binaryRow = binaryRow;
        assert (transactionId == null || commitTableId != null && commitPartitionId != -1);
        assert (transactionId != null || commitTableId == null && commitPartitionId == -1);
        this.transactionId = transactionId;
        this.commitTableId = commitTableId;
        this.commitTs = commitTs;
        this.newestCommitTs = newestCommitTs;
        this.commitPartitionId = commitPartitionId;
    }

    public static ReadResult createFromWriteIntent(BinaryRow binaryRow, UUID transactionId, UUID commitTableId, int commitPartitionId, @Nullable HybridTimestamp lastCommittedTimestamp) {
        return new ReadResult(binaryRow, transactionId, commitTableId, null, lastCommittedTimestamp, commitPartitionId);
    }

    public static ReadResult createFromCommitted(BinaryRow binaryRow, HybridTimestamp commitTs) {
        return new ReadResult(binaryRow, null, null, commitTs, null, -1);
    }

    @Nullable
    public BinaryRow binaryRow() {
        return this.binaryRow;
    }

    @Nullable
    public UUID transactionId() {
        return this.transactionId;
    }

    @Nullable
    public UUID commitTableId() {
        return this.commitTableId;
    }

    @Nullable
    public HybridTimestamp commitTimestamp() {
        return this.commitTs;
    }

    @Nullable
    public HybridTimestamp newestCommitTimestamp() {
        return this.newestCommitTs;
    }

    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    public boolean isWriteIntent() {
        return this.transactionId != null;
    }

    public boolean isEmpty() {
        return this.binaryRow == null;
    }
}

