/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.sources;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import org.apache.ignite.internal.metrics.DoubleGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class OsMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "os";
    private final OperatingSystemMXBean operatingSystemMxBean;
    private boolean enabled;

    OsMetricSource(OperatingSystemMXBean operatingSystemMxBean) {
        this.operatingSystemMxBean = operatingSystemMxBean;
    }

    public OsMetricSource() {
        this.operatingSystemMxBean = ManagementFactory.getOperatingSystemMXBean();
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("LoadAverage", new DoubleGauge("LoadAverage", "System load average for the last minute. System load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated depends on the operating system. If the load average is not available, a negative value is returned.", this.operatingSystemMxBean::getSystemLoadAverage));
        this.enabled = true;
        return new MetricSet(SOURCE_NAME, metrics);
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }
}

