/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.recovery.cluster;

import jakarta.inject.Singleton;
import java.io.IOException;
import org.apache.ignite.internal.cli.call.recovery.cluster.MigrateToClusterCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.ClusterManagementApi;
import org.apache.ignite.rest.client.api.RecoveryApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ClusterState;
import org.apache.ignite.rest.client.model.MigrateRequest;

@Singleton
public class MigrateToClusterCall
implements Call<MigrateToClusterCallInput, String> {
    private final ApiClientFactory clientFactory;

    public MigrateToClusterCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(MigrateToClusterCallInput input) {
        ClusterState newClusterState;
        ClusterManagementApi newClusterManagementClient = new ClusterManagementApi(this.clientFactory.getClient(input.newClusterUrl()));
        RecoveryApi oldRecoveryClient = new RecoveryApi(this.clientFactory.getClient(input.oldClusterUrl()));
        try {
            newClusterState = newClusterManagementClient.clusterState();
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.newClusterUrl()));
        }
        MigrateRequest command = new MigrateRequest();
        command.setCmgNodes(newClusterState.getCmgNodes());
        command.setMetaStorageNodes(newClusterState.getMsNodes());
        command.setVersion(newClusterState.getIgniteVersion());
        command.setClusterId(newClusterState.getClusterTag().getClusterId());
        command.setClusterName(newClusterState.getClusterTag().getClusterName());
        command.setFormerClusterIds(newClusterState.getFormerClusterIds());
        try {
            oldRecoveryClient.migrate(command);
        }
        catch (ApiException e) {
            if (e.getCause() instanceof IOException) {
                return DefaultCallOutput.success("Node has gone, this most probably means that migration is initiated and the node restarts.");
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.oldClusterUrl()));
        }
        return DefaultCallOutput.success("Successfully initiated migration.");
    }
}

