/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binarytuple;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.ignite.internal.lang.IgniteInternalException;

public class BinaryTupleCommon {
    public static final int HEADER_SIZE = 1;
    public static final byte VARLEN_EMPTY_BYTE = -128;
    public static final int VARSIZE_MASK = 3;
    public static final int OFFSET_TABLE_OVERSIZED = 4;
    public static final int PREFIX_FLAG = 8;
    public static final int EQUALITY_FLAG = 16;

    public static byte valueSizeToFlags(long size) {
        if (size <= 255L) {
            return 0;
        }
        if (size <= 65535L) {
            return 1;
        }
        if (size <= Integer.MAX_VALUE) {
            return 2;
        }
        throw new IgniteInternalException("Too big binary tuple size");
    }

    public static int flagsToEntrySize(byte flags) {
        return 1 << (flags & 3);
    }

    public static int valueSizeToEntrySize(long size) {
        if (size <= 255L) {
            return 1;
        }
        if (size <= 65535L) {
            return 2;
        }
        if (size <= Integer.MAX_VALUE) {
            return 4;
        }
        throw new IgniteInternalException("Too big binary tuple size");
    }

    public static BigDecimal shrinkDecimal(BigDecimal value, int scale) {
        BigDecimal noZeros;
        if (value.scale() > scale) {
            value = value.setScale(scale, RoundingMode.HALF_UP);
        }
        if ((noZeros = value.stripTrailingZeros()).scale() <= Short.MAX_VALUE && noZeros.scale() >= Short.MIN_VALUE) {
            return noZeros;
        }
        return value;
    }
}

