/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.consistency;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.consistency.ConsistencyRepairCommandArg;
import org.apache.ignite.internal.management.consistency.ConsistencyRepairTask;
import org.apache.ignite.internal.management.consistency.ConsistencyTaskResult;
import org.apache.ignite.lang.IgniteExperimental;
import org.jetbrains.annotations.Nullable;

@IgniteExperimental
public class ConsistencyRepairCommand
implements LocalCommand<ConsistencyRepairCommandArg, String> {
    @Override
    public String description() {
        return "Check/Repair cache consistency using Read Repair approach";
    }

    @Override
    public Class<ConsistencyRepairCommandArg> argClass() {
        return ConsistencyRepairCommandArg.class;
    }

    @Override
    public String execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, ConsistencyRepairCommandArg arg, Consumer<String> printer) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean failed = false;
        if (arg.parallel()) {
            failed = this.execute(cli, client, ignite, arg, CommandUtils.nodes(cli, client, ignite), sb);
        } else {
            GridClientNode node2;
            Set nodes = CommandUtils.nodes(cli, client, ignite).stream().filter(node -> !node.isClient()).collect(Collectors.toSet());
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext() && !(failed = this.execute(cli, client, ignite, arg, Collections.singleton(node2 = (GridClientNode)iterator.next()), sb))) {
            }
        }
        String res = sb.toString();
        if (failed) {
            throw new IgniteException(res);
        }
        printer.accept(res);
        return res;
    }

    private boolean execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, ConsistencyRepairCommandArg arg, Collection<GridClientNode> nodes, StringBuilder sb) throws Exception {
        boolean failed = false;
        ConsistencyTaskResult res = (ConsistencyTaskResult)CommandUtils.execute(cli, client, ignite, ConsistencyRepairTask.class, arg, nodes);
        if (res.cancelled()) {
            sb.append("Operation execution cancelled.\n\n");
            failed = true;
        }
        if (res.failed()) {
            sb.append("Operation execution failed.\n\n");
            failed = true;
        }
        if (failed) {
            sb.append("[EXECUTION FAILED OR CANCELLED, RESULTS MAY BE INCOMPLETE OR INCONSISTENT]\n\n");
        }
        if (res.message() != null) {
            sb.append(res.message());
        } else assert (!arg.parallel());
        return failed;
    }
}

