/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view.sql;

import java.util.stream.Collectors;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;

public class SqlIndexView {
    private final TableDescriptor tbl;
    private final IndexDescriptor idx;

    public SqlIndexView(TableDescriptor tbl, IndexDescriptor idx) {
        this.tbl = tbl;
        this.idx = idx;
    }

    @Order
    public int cacheGroupId() {
        return this.tbl.cacheInfo().groupId();
    }

    @Order(value=1)
    public String cacheGroupName() {
        return this.tbl.cacheInfo().groupName();
    }

    @Order(value=2)
    public int cacheId() {
        return this.tbl.cacheInfo().cacheId();
    }

    @Order(value=3)
    public String cacheName() {
        return this.tbl.cacheInfo().name();
    }

    @Order(value=4)
    public String schemaName() {
        return this.tbl.type().schemaName();
    }

    @Order(value=5)
    public String tableName() {
        return this.tbl.type().tableName();
    }

    @Order(value=6)
    public String indexName() {
        return this.idx.name();
    }

    @Order(value=7)
    public String indexType() {
        return this.idx.type().name();
    }

    @Order(value=8)
    public String columns() {
        return this.idx.keyDefinitions().entrySet().stream().map(fld -> "\"" + (String)fld.getKey() + "\"" + (((IndexKeyDefinition)fld.getValue()).order().sortOrder() == SortOrder.DESC ? " DESC" : " ASC")).collect(Collectors.joining(", "));
    }

    @Order(value=9)
    public boolean isPk() {
        return this.idx.isPk();
    }

    @Order(value=10)
    public boolean isUnique() {
        return this.idx.isPk() || this.idx.isProxy() && this.idx.targetIdx().isPk();
    }

    @Order(value=11)
    public Integer inlineSize() {
        return this.idx.inlineSize();
    }
}

