/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.metastorage.CommandId;
import org.apache.ignite3.internal.metastorage.CommandIdBuilder;
import org.apache.ignite3.internal.metastorage.CommandIdSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class CommandIdImpl
implements CommandId,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 11;
    @IgniteToStringInclude
    private final long counter;
    @IgniteToStringInclude
    private final UUID nodeId;

    private CommandIdImpl(long counter, UUID nodeId) {
        this.counter = counter;
        this.nodeId = nodeId;
    }

    @Override
    public long counter() {
        return this.counter;
    }

    @Override
    public UUID nodeId() {
        return this.nodeId;
    }

    public MessageSerializer serializer() {
        return CommandIdSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(CommandIdImpl.class, this);
    }

    @Override
    public short messageType() {
        return 11;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CommandIdImpl otherMessage = (CommandIdImpl)other;
        return Objects.equals(this.nodeId, otherMessage.nodeId) && this.counter == otherMessage.counter;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.counter, this.nodeId);
        return result;
    }

    @Override
    public CommandIdImpl clone() {
        try {
            return (CommandIdImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CommandIdBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CommandIdBuilder {
        private long counter;
        private UUID nodeId;

        private Builder() {
        }

        @Override
        public CommandIdBuilder counter(long counter) {
            this.counter = counter;
            return this;
        }

        @Override
        public CommandIdBuilder nodeId(UUID nodeId) {
            Objects.requireNonNull(nodeId, "nodeId is not marked @Nullable");
            this.nodeId = nodeId;
            return this;
        }

        @Override
        public long counter() {
            return this.counter;
        }

        @Override
        public UUID nodeId() {
            return this.nodeId;
        }

        @Override
        public CommandId build() {
            return new CommandIdImpl(this.counter, Objects.requireNonNull(this.nodeId, "nodeId is not marked @Nullable"));
        }
    }
}

