/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.nio.ByteBuffer;
import java.util.function.ToIntFunction;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.lang.InternalTuple;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.util.ColocationUtils;
import org.apache.ignite3.internal.util.HashCalculator;

public class SqlOutputBinaryRow
extends BinaryTupleReader
implements BinaryRowEx {
    private final int schemaVersion;
    private final int colocationHash;

    private SqlOutputBinaryRow(int schemaVersion, int colocationHash, int numElements, ByteBuffer buffer) {
        super(numElements, buffer);
        this.schemaVersion = schemaVersion;
        this.colocationHash = colocationHash;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public int tupleSliceLength() {
        return this.byteBuffer().remaining();
    }

    @Override
    public ByteBuffer tupleSlice() {
        return this.byteBuffer();
    }

    @Override
    public int colocationHash() {
        return this.colocationHash;
    }

    static SqlOutputBinaryRow newRow(SchemaDescriptor descriptor, InternalTuple binaryTuple) {
        return SqlOutputBinaryRow.newRow0(descriptor, binaryTuple, Column::positionInRow);
    }

    static SqlOutputBinaryRow newKeyRow(SchemaDescriptor descriptor, InternalTuple binaryTuple) {
        return SqlOutputBinaryRow.newRow0(descriptor, binaryTuple, Column::positionInKey);
    }

    private static SqlOutputBinaryRow newRow0(SchemaDescriptor descriptor, InternalTuple binaryTuple, ToIntFunction<Column> columnPosition) {
        HashCalculator hashCalc = new HashCalculator();
        for (Column column : descriptor.colocationColumns()) {
            int idx = columnPosition.applyAsInt(column);
            assert (idx >= 0) : column;
            Object value = Commons.readValue(binaryTuple, column.type(), idx);
            ColocationUtils.append(hashCalc, value, column.type());
        }
        int colocationHash = hashCalc.hash();
        return new SqlOutputBinaryRow(descriptor.version(), colocationHash, binaryTuple.elementCount(), binaryTuple.byteBuffer());
    }
}

