/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.TargetHealth;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TargetHealthStaxUnmarshaller
implements Unmarshaller<TargetHealth, StaxUnmarshallerContext> {
    private static TargetHealthStaxUnmarshaller instance;

    public TargetHealth unmarshall(StaxUnmarshallerContext context) throws Exception {
        TargetHealth targetHealth = new TargetHealth();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return targetHealth;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("State", targetDepth)) {
                    targetHealth.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Reason", targetDepth)) {
                    targetHealth.setReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                targetHealth.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return targetHealth;
    }

    public static TargetHealthStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TargetHealthStaxUnmarshaller();
        }
        return instance;
    }
}

