/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc.dialect;

import java.util.Collection;
import org.apache.ignite.cache.store.jdbc.dialect.BasicJdbcDialect;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;

public class DB2Dialect
extends BasicJdbcDialect {
    private static final long serialVersionUID = 0L;

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = DB2Dialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROW_NUMBER() OVER(ORDER BY %1$s) AS rn FROM %2$s) WHERE mod(rn, ?) = 0 ORDER BY %1$s", cols, fullTblName);
    }

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection<String> cols = F.concat(false, keyCols, uniqCols);
        String colsLst = DB2Dialect.mkString(cols, ", ");
        String match = DB2Dialect.mkString(keyCols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("t.%s=v.%s", col, col);
            }
        }, "", ", ", "");
        String setCols = DB2Dialect.mkString(uniqCols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return String.format("t.%s = v.%s", col, col);
            }
        }, "", ", ", "");
        String valuesCols = DB2Dialect.mkString(cols, new C1<String, String>(){

            @Override
            public String apply(String col) {
                return "v." + col;
            }
        }, "", ", ", "");
        return String.format("MERGE INTO %s t USING (VALUES(%s)) AS v (%s)  ON %s WHEN MATCHED THEN  UPDATE SET %s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s)", fullTblName, DB2Dialect.repeat("?", cols.size(), "", ",", ""), colsLst, match, setCols, colsLst, valuesCols);
    }
}

