/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.security.AccessControlException;
import java.util.UUID;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.lang.IgniteBiPredicate;

public class SecurityAwareBiPredicate<E1, E2>
extends AbstractSecurityAwareExternalizable<IgniteBiPredicate<E1, E2>>
implements IgniteBiPredicate<E1, E2> {
    private static final long serialVersionUID = 0L;

    public SecurityAwareBiPredicate() {
    }

    public SecurityAwareBiPredicate(UUID subjectId, IgniteBiPredicate<E1, E2> original) {
        super(subjectId, original);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply(E1 e1, E2 e2) {
        IgniteSecurity security = this.ignite.context().security();
        try (OperationSecurityContext c = security.withContext(this.subjectId);){
            IgniteSandbox sandbox = security.sandbox();
            boolean bl = sandbox.enabled() ? sandbox.execute(() -> ((IgniteBiPredicate)this.original).apply(e1, e2)).booleanValue() : ((IgniteBiPredicate)this.original).apply(e1, e2);
            return bl;
        }
        catch (AccessControlException e) {
            this.logAccessDeniedMessage(e);
            throw e;
        }
    }
}

