/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.plugin.extensions.communication.IgniteMessageFactory;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFactoryProvider;
import org.jetbrains.annotations.Nullable;

public class IgniteMessageFactoryImpl
implements IgniteMessageFactory {
    private static final int OFF = 32768;
    private static final int ARR_SIZE = 65536;
    private final Supplier<Message>[] msgSuppliers = (Supplier[])Array.newInstance(Supplier.class, 65536);
    private boolean initialized;
    private int minIdx = Integer.MAX_VALUE;
    private int maxIdx = -1;
    private int cnt;

    public IgniteMessageFactoryImpl(MessageFactory[] factories) {
        if (factories == null || factories.length == 0) {
            throw new IllegalArgumentException("Message factory couldn't be initialized. Factories aren't provided.");
        }
        ArrayList<MessageFactory> old = new ArrayList<MessageFactory>(factories.length);
        for (MessageFactory factory : factories) {
            if (factory instanceof MessageFactoryProvider) {
                MessageFactoryProvider p = (MessageFactoryProvider)factory;
                p.registerAll(this);
                continue;
            }
            old.add(factory);
        }
        if (!old.isEmpty()) {
            for (int i = 0; i < 65536; ++i) {
                Supplier<Message> curr = this.msgSuppliers[i];
                if (curr != null) continue;
                short directType = IgniteMessageFactoryImpl.indexToDirectType(i);
                for (MessageFactory factory : old) {
                    Message msg = factory.create(directType);
                    if (msg == null) continue;
                    this.register(directType, () -> factory.create(directType));
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public void register(short directType, Supplier<Message> supplier) throws IgniteException {
        if (this.initialized) {
            throw new IllegalStateException("Message factory is already initialized. Registration of new message types is forbidden.");
        }
        int idx = IgniteMessageFactoryImpl.directTypeToIndex(directType);
        Supplier<Message> curr = this.msgSuppliers[idx];
        if (curr == null) {
            this.msgSuppliers[idx] = supplier;
            this.minIdx = Math.min(idx, this.minIdx);
            this.maxIdx = Math.max(idx, this.maxIdx);
            ++this.cnt;
        } else {
            throw new IgniteException("Message factory is already registered for direct type: " + directType);
        }
    }

    @Override
    @Nullable
    public Message create(short directType) {
        Supplier<Message> supplier = this.msgSuppliers[IgniteMessageFactoryImpl.directTypeToIndex(directType)];
        if (supplier == null) {
            throw new IgniteException("Invalid message type: " + directType);
        }
        return supplier.get();
    }

    public short[] registeredDirectTypes() {
        short[] res = new short[this.cnt];
        if (this.cnt > 0) {
            int p = 0;
            for (int i = this.minIdx; i <= this.maxIdx; ++i) {
                if (this.msgSuppliers[i] == null) continue;
                res[p++] = IgniteMessageFactoryImpl.indexToDirectType(i);
            }
        }
        return res;
    }

    private static int directTypeToIndex(short directType) {
        return directType + 32768;
    }

    private static short indexToDirectType(int idx) {
        int res = idx - 32768;
        assert (res >= Short.MIN_VALUE && res <= Short.MAX_VALUE);
        return (short)res;
    }
}

