/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.index.common;

import org.apache.iotdb.db.exception.index.UnsupportedIndexTypeException;
import org.apache.iotdb.tsfile.exception.NotImplementedException;

public enum IndexType {
    NO_INDEX,
    RTREE_PAA,
    ELB_INDEX,
    KV_INDEX;


    public static IndexType deserialize(short i) {
        switch (i) {
            case 0: {
                return NO_INDEX;
            }
            case 1: {
                return RTREE_PAA;
            }
            case 2: {
                return ELB_INDEX;
            }
            case 3: {
                return KV_INDEX;
            }
        }
        throw new NotImplementedException("Given index is not implemented");
    }

    public static int getSerializedSize() {
        return 2;
    }

    public short serialize() {
        switch (this) {
            case NO_INDEX: {
                return 0;
            }
            case RTREE_PAA: {
                return 1;
            }
            case ELB_INDEX: {
                return 2;
            }
            case KV_INDEX: {
                return 3;
            }
        }
        throw new NotImplementedException("Given index is not implemented");
    }

    public static IndexType getIndexType(String indexTypeString) throws UnsupportedIndexTypeException {
        String normalized = indexTypeString.toUpperCase();
        try {
            return IndexType.valueOf(normalized);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedIndexTypeException(indexTypeString);
        }
    }
}

