/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.manage;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSessionManager
extends SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(ClusterSessionManager.class);
    private Coordinator coordinator;
    private Map<Long, RemoteQueryContext> queryContextMap = new ConcurrentHashMap<Long, RemoteQueryContext>();

    protected ClusterSessionManager() {
    }

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void putContext(long queryId, RemoteQueryContext context) {
        this.queryContextMap.put(queryId, context);
    }

    public void releaseQueryResource(long queryId) throws StorageEngineException {
        super.releaseQueryResource(queryId);
        this.releaseRemoteQueryResource(queryId);
    }

    public void releaseRemoteQueryResource(long queryId) {
        RemoteQueryContext context = this.queryContextMap.remove(queryId);
        if (context != null) {
            for (Map.Entry<RaftNode, Set<Node>> headerEntry : context.getQueriedNodesMap().entrySet()) {
                RaftNode header = headerEntry.getKey();
                Set<Node> queriedNodes = headerEntry.getValue();
                for (Node queriedNode : queriedNodes) {
                    this.releaseQueryResourceForOneNode(queryId, header, queriedNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseQueryResourceForOneNode(long queryId, RaftNode header, Node queriedNode) {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            GenericHandler handler = new GenericHandler(queriedNode, new AtomicReference());
            try {
                AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(queriedNode, ClusterConstant.getReadOperationTimeoutMS());
                client.endQuery(header, this.coordinator.getThisNode(), queryId, handler);
            }
            catch (IOException | TException e) {
                logger.error("Cannot end query {} in {}", (Object)queryId, (Object)queriedNode);
            }
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(queriedNode, ClusterConstant.getReadOperationTimeoutMS());
                syncDataClient.endQuery(header, this.coordinator.getThisNode(), queryId);
            }
            catch (IOException | TException e) {
                if (syncDataClient != null) {
                    syncDataClient.close();
                }
                logger.error("Cannot end query {} in {}", (Object)queryId, (Object)queriedNode);
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
    }

    public static ClusterSessionManager getInstance() {
        return ClusterSessionManagerHolder.INSTANCE;
    }

    private static class ClusterSessionManagerHolder {
        private static final ClusterSessionManager INSTANCE = new ClusterSessionManager();

        private ClusterSessionManagerHolder() {
        }
    }
}

