/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

public class CountWindow
implements IWindow {
    private final int controlColumnIndex;
    private final boolean needOutputEndTime;
    private final boolean ignoreNull;
    private final long countNumber;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private long leftCount;

    public CountWindow(CountWindowParameter countWindowParameter) {
        this.controlColumnIndex = countWindowParameter.getControlColumnIndex();
        this.needOutputEndTime = countWindowParameter.isNeedOutputEndTime();
        this.countNumber = countWindowParameter.getCountNumber();
        this.ignoreNull = countWindowParameter.isIgnoreNull();
        this.resetCurCount();
    }

    @Override
    public Column getControlColumn(TsBlock tsBlock) {
        return tsBlock.getColumn(this.controlColumnIndex);
    }

    @Override
    public boolean satisfy(Column column, int index) {
        return this.leftCount != 0L;
    }

    @Override
    public void mergeOnePoint(Column[] timeAndValueColumn, int index) {
        long currentTime = timeAndValueColumn[1].getLong(index);
        this.startTime = Math.min(this.startTime, currentTime);
        this.endTime = Math.max(this.endTime, currentTime);
        --this.leftCount;
    }

    @Override
    public boolean contains(Column column) {
        return false;
    }

    public boolean isNeedOutputEndTime() {
        return this.needOutputEndTime;
    }

    public void resetCurCount() {
        this.setLeftCount(this.countNumber);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getLeftCount() {
        return this.leftCount;
    }

    public void setLeftCount(long leftCount) {
        this.leftCount = leftCount;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

