/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.ordered.ReversibleIterable;
import org.eclipse.collections.api.partition.list.PartitionList;
import org.eclipse.collections.api.tuple.Pair;

public interface ListIterable<T>
extends ReversibleIterable<T> {
    public T get(int var1);

    public int lastIndexOf(Object var1);

    @Override
    public T getFirst();

    @Override
    public T getLast();

    public ListIterator<T> listIterator();

    public ListIterator<T> listIterator(int var1);

    public ImmutableList<T> toImmutable();

    @Override
    public ListIterable<T> tap(Procedure<? super T> var1);

    @Override
    public ListIterable<T> select(Predicate<? super T> var1);

    @Override
    public <P> ListIterable<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ListIterable<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ListIterable<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionList<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionList<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ListIterable<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> ListIterable<V> collect(Function<? super T, ? extends V> var1);

    @Override
    default public <V> ListIterable<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    default public ListIterable<T> selectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.select((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    default public ListIterable<T> rejectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.select((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    public BooleanList collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ByteList collectByte(ByteFunction<? super T> var1);

    @Override
    public CharList collectChar(CharFunction<? super T> var1);

    @Override
    public DoubleList collectDouble(DoubleFunction<? super T> var1);

    @Override
    public FloatList collectFloat(FloatFunction<? super T> var1);

    @Override
    public IntList collectInt(IntFunction<? super T> var1);

    @Override
    public LongList collectLong(LongFunction<? super T> var1);

    @Override
    public ShortList collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ListIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ListIterable<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> ListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ListIterable<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public <V> ListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> ListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public ListIterable<T> distinct();

    public ListIterable<T> distinct(HashingStrategy<? super T> var1);

    public <V> ListIterable<T> distinctBy(Function<? super T, ? extends V> var1);

    @Override
    public <S> ListIterable<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public ListIterable<Pair<T, Integer>> zipWithIndex();

    @Override
    public ListIterable<T> take(int var1);

    @Override
    public ListIterable<T> takeWhile(Predicate<? super T> var1);

    @Override
    public ListIterable<T> drop(int var1);

    @Override
    public ListIterable<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionList<T> partitionWhile(Predicate<? super T> var1);

    @Override
    public ListIterable<T> toReversed();

    @Beta
    public ParallelListIterable<T> asParallel(ExecutorService var1, int var2);

    default public int binarySearch(T key, Comparator<? super T> comparator) {
        return Collections.binarySearch((List)((Object)this), key, comparator);
    }

    default public int binarySearch(T key) {
        return Collections.binarySearch((List)((Object)this), key);
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ListIterable<T> subList(int var1, int var2);

    default public <T2> void forEachInBoth(ListIterable<T2> other, Procedure2<? super T, ? super T2> procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two Lists of different sizes :" + this.size() + ':' + other.size());
        }
        this.forEachWithIndex((each, index) -> procedure.value((Object)each, (Object)other.get(index)));
    }
}

