/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class QuotedPrintableTextEncodeTest {
    @Test
    public void testEscapedSoftBreak() throws Exception {
        byte[] content = new byte[500];
        Arrays.fill(content, (byte)24);
        byte[] expected = new byte[1557];
        int index = 0;
        for (int l = 0; l < 20; ++l) {
            for (int i = 0; i < 25; ++i) {
                expected[index++] = 61;
                expected[index++] = 49;
                expected[index++] = 56;
            }
            if (l >= 19) continue;
            expected[index++] = 61;
            expected[index++] = 13;
            expected[index++] = 10;
        }
        this.check(content, expected);
    }

    @Test
    public void testPlainAsciiSoftBreak() throws Exception {
        byte[] content = new byte[500];
        Arrays.fill(content, (byte)41);
        byte[] expected = new byte[518];
        Arrays.fill(expected, (byte)41);
        expected[75] = 61;
        expected[76] = 13;
        expected[77] = 10;
        expected[153] = 61;
        expected[154] = 13;
        expected[155] = 10;
        expected[231] = 61;
        expected[232] = 13;
        expected[233] = 10;
        expected[309] = 61;
        expected[310] = 13;
        expected[311] = 10;
        expected[387] = 61;
        expected[388] = 13;
        expected[389] = 10;
        expected[465] = 61;
        expected[466] = 13;
        expected[467] = 10;
        this.check(content, expected);
    }

    @Test
    public void testPlainASCII() throws Exception {
        this.checkRoundtrip("Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.Thisisaverysimplemessage.");
    }

    @Test
    public void testEncodeSpace() throws Exception {
        this.checkRoundtrip("                 A");
    }

    @Test
    public void testLetterEncoding() throws Exception {
        for (byte b = 0; b < 127; b = (byte)((byte)(b + 1))) {
            byte[] content = new byte[]{b};
            if (b == 10 || b == 13 || b == 32 || b == 9) continue;
            this.checkRoundtrip(content);
        }
    }

    @Test
    public void testCRLFShouldResetLineCount() throws Exception {
        StringBuilder buffer = new StringBuilder(4096);
        for (int i = 0; i < 1000; ++i) {
            buffer.append("Hugo\r\n");
        }
        String longLine = buffer.toString();
        this.check(longLine, longLine);
    }

    @Test
    public void testDontEscapeLF() throws Exception {
        this.check("Ready\nFor\n", "Ready\nFor\n");
    }

    @Test
    public void testDontEscapeCR() throws Exception {
        this.check("Ready\rFor\r", "Ready\rFor\r");
    }

    @Test
    public void testEscapeSpaceAtLineEnd() throws Exception {
        this.check("      \r\n", "     =20\r\n");
    }

    @Test
    public void testDontEscapeSpaceBeforeLineEnd() throws Exception {
        this.check("      ", "      ");
    }

    @Test
    public void testDontEscapeTabsBeforeLineEnd() throws Exception {
        this.check("\t\t\t\t", "\t\t\t\t");
    }

    @Test
    public void testDontWhiteSpaceBeforeLineEnd() throws Exception {
        this.check("  \t\t  \t", "  \t\t  \t");
    }

    private void checkRoundtrip(String content) throws Exception {
        this.checkRoundtrip(content, Charsets.US_ASCII);
    }

    private void checkRoundtrip(String content, Charset charset) throws Exception {
        this.checkRoundtrip(charset.encode(content).array());
    }

    private void checkRoundtrip(byte[] content) throws Exception {
        InputStream in = InputStreams.create((byte[])content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncoderUtil.encodeQ((InputStream)in, (OutputStream)out);
        in = new QuotedPrintableInputStream(InputStreams.create((byte[])out.toByteArray()));
        byte[] buf = ContentUtil.buffer((InputStream)in);
        this.assertEquals(content, buf);
    }

    private void check(String content, String expected) throws Exception {
        this.check(ContentUtil.toAsciiByteArray((String)content), ContentUtil.toAsciiByteArray((String)expected));
    }

    private void check(byte[] content, byte[] expected) throws Exception {
        InputStream in = InputStreams.create((byte[])content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncoderUtil.encodeQ((InputStream)in, (OutputStream)out);
        this.assertEquals(expected, out.toByteArray());
    }

    private void assertEquals(byte[] expected, byte[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((String)("Mismatch@" + i), (long)expected[i], (long)actual[i]);
        }
    }
}

