/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorSession;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.CompilerControlPlugin;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.HelperMethodInvocation;
import org.openjdk.jmh.generators.core.HelperType;
import org.openjdk.jmh.generators.core.Identifiers;
import org.openjdk.jmh.generators.core.MethodGroup;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.Paddings;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.generators.core.StateObject;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Utils;

class StateObjectHandler {
    private final CompilerControlPlugin compileControl;
    private final Identifiers identifiers;
    private final Multimap<String, StateObject> roots;
    private final Multimap<String, ClassInfo> specials;
    private final Set<StateObject> stateObjects;
    private final Map<String, StateObject> implicits;
    private final Multimap<String, String> benchmarkArgs;
    private final Multimap<String, String> auxNames = new HashMultimap<String, String>();
    private final Map<String, AuxCounters.Type> auxType = new HashMap<String, AuxCounters.Type>();
    private final Map<String, String> auxAccessors = new HashMap<String, String>();
    private final Map<String, Boolean> auxResettable = new HashMap<String, Boolean>();

    public StateObjectHandler(CompilerControlPlugin compileControl) {
        this.compileControl = compileControl;
        this.roots = new HashMultimap<String, StateObject>();
        this.benchmarkArgs = new HashMultimap<String, String>();
        this.implicits = new HashMap<String, StateObject>();
        this.specials = new HashMultimap<String, ClassInfo>();
        this.stateObjects = new HashSet<StateObject>();
        this.identifiers = new Identifiers();
    }

    public static void validateState(ClassInfo state) {
        try {
            State ann = BenchmarkGeneratorUtils.getAnnSuper(state, State.class);
            if (ann != null) {
                ann.value();
            }
        }
        catch (IncompleteAnnotationException iae) {
            throw new GenerationException("The @" + State.class.getSimpleName() + " annotation should have the explicit " + Scope.class.getSimpleName() + " argument", state);
        }
        if (!state.isPublic()) {
            throw new GenerationException("The instantiated @" + State.class.getSimpleName() + " annotation only supports public classes.", state);
        }
        if (state.isFinal()) {
            throw new GenerationException("The instantiated @" + State.class.getSimpleName() + " annotation does not support final classes.", state);
        }
        if (state.isInner()) {
            throw new GenerationException("The instantiated @" + State.class.getSimpleName() + " annotation does not support inner classes, make sure your class is static.", state);
        }
        if (state.isAbstract()) {
            throw new GenerationException("The instantiated @" + State.class.getSimpleName() + " class cannot be abstract.", state);
        }
        boolean hasDefaultConstructor = false;
        for (MethodInfo constructor : state.getConstructors()) {
            if (!constructor.getParameters().isEmpty()) continue;
            hasDefaultConstructor = constructor.isPublic();
            break;
        }
        hasDefaultConstructor |= state.getQualifiedName().equals(BenchmarkParams.class.getCanonicalName());
        hasDefaultConstructor |= state.getQualifiedName().equals(IterationParams.class.getCanonicalName());
        if (!(hasDefaultConstructor |= state.getQualifiedName().equals(ThreadParams.class.getCanonicalName()))) {
            throw new GenerationException("The @" + State.class.getSimpleName() + " annotation can only be applied to the classes having the default public constructor.", state);
        }
        BenchmarkGeneratorUtils.checkAnnotations(state);
        for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(state)) {
            BenchmarkGeneratorUtils.checkAnnotations(fi);
        }
        for (MethodInfo mi : BenchmarkGeneratorUtils.getMethods(state)) {
            BenchmarkGeneratorUtils.checkAnnotations(mi);
        }
        for (MethodInfo mi : BenchmarkGeneratorUtils.getAllMethods(state)) {
            if (mi.getAnnotation(Setup.class) == null && mi.getAnnotation(TearDown.class) == null) continue;
            StateObjectHandler.validateStateArgs(mi);
        }
    }

    public static void validateStateArgs(MethodInfo e) {
        for (ParameterInfo var : e.getParameters()) {
            if (BenchmarkGeneratorUtils.getAnnSuper(var.getType(), State.class) != null || StateObjectHandler.isSpecialClass(var.getType())) continue;
            throw new GenerationException("Method parameters should be either @" + State.class.getSimpleName() + " classes or one of special JMH classes (*Params, Blackhole, Control)", e);
        }
    }

    private static boolean isSpecialClass(ClassInfo ci) {
        String name = ci.getQualifiedName();
        return name.equals(BenchmarkParams.class.getCanonicalName()) || name.equals(IterationParams.class.getCanonicalName()) || name.equals(ThreadParams.class.getCanonicalName()) || name.equals(Blackhole.class.getCanonicalName()) || name.equals(Control.class.getCanonicalName());
    }

    private String getSpecialClassAccessor(ClassInfo pci) {
        String name = pci.getQualifiedName();
        if (name.equals(BenchmarkParams.class.getCanonicalName())) {
            return "benchmarkParams";
        }
        if (name.equals(IterationParams.class.getCanonicalName())) {
            return "iterationParams";
        }
        if (name.equals(ThreadParams.class.getCanonicalName())) {
            return "threadParams";
        }
        if (name.equals(Blackhole.class.getCanonicalName())) {
            return "blackhole";
        }
        if (name.equals(Control.class.getCanonicalName())) {
            return "notifyControl";
        }
        throw new GenerationException("Internal error, unhandled special class: " + pci, pci);
    }

    public State getState(ClassInfo ci, ParameterInfo pi) {
        State ann = BenchmarkGeneratorUtils.getAnnSuper(ci, State.class);
        if (ann == null) {
            throw new GenerationException("The method parameter is not a @" + State.class.getSimpleName() + ": ", pi);
        }
        return ann;
    }

    public void bindMethods(ClassInfo holder, MethodGroup mg) {
        for (MethodInfo method : mg.methods()) {
            State ann = BenchmarkGeneratorUtils.getAnnSuper(holder, State.class);
            Scope scope = ann != null ? ann.value() : Scope.Thread;
            StateObject holderSo = new StateObject(this.identifiers, holder, scope);
            this.stateObjects.add(holderSo);
            this.implicits.put("bench", holderSo);
            this.bindState(method, holderSo, holder);
            this.resolveDependencies(method, holder, holderSo);
            StateObjectHandler.validateStateArgs(method);
            for (ParameterInfo ppi : method.getParameters()) {
                ClassInfo pci = ppi.getType();
                if (StateObjectHandler.isSpecialClass(pci)) {
                    this.benchmarkArgs.put(method.getName(), this.getSpecialClassAccessor(pci));
                    this.specials.put(method.getName(), pci);
                    continue;
                }
                StateObject pso = new StateObject(this.identifiers, pci, this.getState(pci, ppi).value());
                this.stateObjects.add(pso);
                this.roots.put(method.getName(), pso);
                this.benchmarkArgs.put(method.getName(), pso.toLocal());
                this.bindState(method, pso, pci);
                this.resolveDependencies(method, pci, pso);
            }
        }
    }

    public static void validateNoCycles(MethodInfo method) {
        StateObjectHandler.validateNoCyclesStep(Collections.emptySet(), method, true);
    }

    private static void validateNoCyclesStep(Set<ClassQName> alreadySeen, MethodInfo method, boolean includeHolder) {
        HashSet<ClassQName> outgoing = new HashSet<ClassQName>();
        if (includeHolder) {
            outgoing.add(new ClassQName(method.getDeclaringClass()));
        }
        for (ParameterInfo ppi : method.getParameters()) {
            outgoing.add(new ClassQName(ppi.getType()));
        }
        if (outgoing.isEmpty()) {
            return;
        }
        HashSet<ClassQName> currentSeen = new HashSet<ClassQName>();
        currentSeen.addAll(alreadySeen);
        for (ClassQName ci : outgoing) {
            if (!currentSeen.add(ci)) {
                throw new GenerationException("@" + State.class.getSimpleName() + " dependency cycle is detected: " + ci.ci.getQualifiedName() + " " + currentSeen, method);
            }
            HashSet<ClassQName> nextSeen = new HashSet<ClassQName>();
            nextSeen.addAll(alreadySeen);
            nextSeen.add(ci);
            for (MethodInfo mi : BenchmarkGeneratorUtils.getMethods(ci.ci)) {
                if (mi.getAnnotation(Setup.class) == null && mi.getAnnotation(TearDown.class) == null) continue;
                StateObjectHandler.validateNoCyclesStep(nextSeen, mi, false);
            }
        }
    }

    private void resolveDependencies(MethodInfo method, ClassInfo pci, StateObject pso) {
        for (MethodInfo mi : BenchmarkGeneratorUtils.getMethods(pci)) {
            if (mi.getAnnotation(Setup.class) == null && mi.getAnnotation(TearDown.class) == null) continue;
            for (ParameterInfo pi : mi.getParameters()) {
                ClassInfo ci = pi.getType();
                if (StateObjectHandler.isSpecialClass(ci)) {
                    pso.helperArgs.put(mi.getQualifiedName(), this.getSpecialClassAccessor(ci));
                    this.specials.put(mi.getQualifiedName(), ci);
                    continue;
                }
                StateObject so = new StateObject(this.identifiers, ci, this.getState(ci, pi).value());
                this.stateObjects.add(so);
                pso.helperArgs.put(mi.getQualifiedName(), so.toLocal());
                if (pso.depends.contains(so)) continue;
                pso.depends.add(so);
                this.bindState(method, so, ci);
                this.resolveDependencies(method, ci, so);
            }
        }
    }

    private void bindState(MethodInfo execMethod, StateObject so, ClassInfo ci) {
        StateObjectHandler.validateState(ci);
        AuxCounters auxCountAnn = ci.getAnnotation(AuxCounters.class);
        if (auxCountAnn != null) {
            String prev;
            String meth;
            String name;
            if (so.scope != Scope.Thread) {
                throw new GenerationException("@" + AuxCounters.class.getSimpleName() + " can only be used with " + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Thread) + " states.", ci);
            }
            for (FieldInfo fieldInfo : ci.getFields()) {
                if (!fieldInfo.isPublic()) continue;
                if (!this.isAuxCompatible(fieldInfo.getType().getQualifiedName())) {
                    throw new GenerationException("Illegal type for the public field in @" + AuxCounters.class.getSimpleName() + ".", fieldInfo);
                }
                name = fieldInfo.getName();
                meth = execMethod.getName();
                this.auxNames.put(meth, name);
                this.auxType.put(name, auxCountAnn.value());
                this.auxResettable.put(name, true);
                prev = this.auxAccessors.put(meth + name, so.localIdentifier + "." + name);
                if (prev == null) continue;
                throw new GenerationException("Conflicting @" + AuxCounters.class.getSimpleName() + " counters. Make sure there are no @" + State.class.getSimpleName() + "-s with the same counter  injected into this method.", fieldInfo);
            }
            for (MethodInfo methodInfo : ci.getMethods()) {
                if (!methodInfo.isPublic() || methodInfo.getReturnType().equals("void")) continue;
                if (!this.isAuxCompatible(methodInfo.getReturnType())) {
                    throw new GenerationException("Illegal type for the return type of public method in @" + AuxCounters.class.getSimpleName() + ".", methodInfo);
                }
                name = methodInfo.getName();
                meth = execMethod.getName();
                this.auxNames.put(meth, name);
                this.auxType.put(name, auxCountAnn.value());
                this.auxResettable.put(name, false);
                prev = this.auxAccessors.put(meth + name, so.localIdentifier + "." + name + "()");
                if (prev == null) continue;
                throw new GenerationException("Conflicting @" + AuxCounters.class.getSimpleName() + " counters. Make sure there are no @" + State.class.getSimpleName() + "-s with the same counter  injected into this method.", methodInfo);
            }
        }
        for (FieldInfo fieldInfo : BenchmarkGeneratorUtils.getAllFields(ci)) {
            if (fieldInfo.getAnnotation(Param.class) == null) continue;
            this.checkParam(fieldInfo);
            so.addParam(fieldInfo);
        }
        for (MethodInfo methodInfo : BenchmarkGeneratorUtils.getMethods(ci)) {
            TearDown tearDownAnn;
            Setup setupAnn = methodInfo.getAnnotation(Setup.class);
            if (setupAnn != null) {
                this.checkHelpers(methodInfo, Setup.class);
                so.addHelper(new HelperMethodInvocation(methodInfo, so, setupAnn.value(), HelperType.SETUP));
                this.compileControl.defaultForceInline(methodInfo);
            }
            if ((tearDownAnn = methodInfo.getAnnotation(TearDown.class)) == null) continue;
            this.checkHelpers(methodInfo, TearDown.class);
            so.addHelper(new HelperMethodInvocation(methodInfo, so, tearDownAnn.value(), HelperType.TEARDOWN));
            this.compileControl.defaultForceInline(methodInfo);
        }
    }

    private boolean isAuxCompatible(String typeName) {
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            return true;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            return true;
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            return true;
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            return true;
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            return true;
        }
        return typeName.equals("double") || typeName.equals("java.lang.Double");
    }

    private void checkParam(FieldInfo fi) {
        if (fi.isFinal()) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " annotation is not acceptable on final fields.", fi);
        }
        if (BenchmarkGeneratorUtils.getAnnSyntax(fi.getDeclaringClass(), State.class) == null) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " annotation should be placed in @" + State.class.getSimpleName() + "-annotated class.", fi);
        }
        ClassInfo type = fi.getType();
        if (!this.isParamTypeAcceptable(type)) {
            throw new GenerationException("@" + Param.class.getSimpleName() + " can only be placed over the annotation-compatible types: primitives, primitive wrappers, Strings, or enums.", fi);
        }
        String[] values = fi.getAnnotation(Param.class).value();
        if (values.length == 1 && values[0].equalsIgnoreCase("blank_blank_blank_2014")) {
            if (!fi.getType().isEnum()) {
                throw new GenerationException("@" + Param.class.getSimpleName() + " should provide the default parameters.", fi);
            }
        } else {
            for (String val : values) {
                if (this.isParamValueConforming(fi, val, type)) continue;
                throw new GenerationException("Some @" + Param.class.getSimpleName() + " values can not be converted to target type: \"" + val + "\" can not be converted to " + type, fi);
            }
        }
    }

    private boolean isParamTypeAcceptable(ClassInfo type) {
        String typeName = type.getQualifiedName();
        if (type.isEnum()) {
            return true;
        }
        if (typeName.equals("java.lang.String")) {
            return true;
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return true;
        }
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            return true;
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return true;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            return true;
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            return true;
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            return true;
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            return true;
        }
        return typeName.equals("double") || typeName.equals("java.lang.Double");
    }

    private boolean isParamValueConforming(FieldInfo fi, String val, ClassInfo type) {
        String typeName = type.getQualifiedName();
        if (type.isEnum() && type.getEnumConstants().contains(val)) {
            return true;
        }
        if (typeName.equals("java.lang.String")) {
            return true;
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return val.equals("true") || val.equals("false");
        }
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            try {
                Byte.parseByte(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return val.length() == 1;
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            try {
                Short.parseShort(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            try {
                Integer.parseInt(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            try {
                Float.parseFloat(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            try {
                Long.parseLong(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
            try {
                Double.parseDouble(val);
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    private void checkHelpers(MethodInfo mi, Class<? extends Annotation> annClass) {
        if (BenchmarkGeneratorUtils.getAnnSuper(mi.getDeclaringClass(), State.class) == null && !mi.getDeclaringClass().isAbstract()) {
            throw new GenerationException("@" + annClass.getSimpleName() + " annotation is placed within a class not having @" + State.class.getSimpleName() + " annotation. This is prohibited because it would have no effect.", mi);
        }
        if (!mi.isPublic()) {
            throw new GenerationException("@" + annClass.getSimpleName() + " method should be public.", mi);
        }
        if (!mi.getReturnType().equalsIgnoreCase("void")) {
            throw new GenerationException("@" + annClass.getSimpleName() + " method should not return anything.", mi);
        }
    }

    public String getBenchmarkArgList(MethodInfo methodInfo) {
        return Utils.join(this.benchmarkArgs.get(methodInfo.getName()), ", ");
    }

    public String getArgList(MethodInfo methodInfo) {
        return this.getArgList(this.stateOrder(methodInfo, false));
    }

    public String getArgList(Collection<StateObject> sos) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StateObject so : sos) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(so.toLocal());
            ++i;
        }
        return sb.toString();
    }

    public String getTypeArgList(MethodInfo methodInfo) {
        return this.getTypeArgList(this.stateOrder(methodInfo, false));
    }

    public String getTypeArgList(Collection<StateObject> sos) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StateObject so : sos) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(so.toTypeDef());
            ++i;
        }
        return sb.toString();
    }

    @SafeVarargs
    public static Collection<StateObject> cons(Collection<StateObject> ... colls) {
        TreeSet<StateObject> r = new TreeSet<StateObject>(StateObject.ID_COMPARATOR);
        for (Collection<StateObject> coll : colls) {
            r.addAll(coll);
        }
        return r;
    }

    public Collection<String> getHelperBlock(MethodInfo method, Level helperLevel, HelperType type) {
        Collection<String> args;
        ArrayList<StateObject> statesForward = new ArrayList<StateObject>();
        block0: for (StateObject stateObject : this.stateOrder(method, true)) {
            for (HelperMethodInvocation helperMethodInvocation : stateObject.getHelpers()) {
                if (helperMethodInvocation.helperLevel != helperLevel) continue;
                statesForward.add(stateObject);
                continue block0;
            }
        }
        ArrayList<StateObject> statesReverse = new ArrayList<StateObject>();
        block2: for (StateObject so : this.stateOrder(method, false)) {
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != helperLevel) continue;
                statesReverse.add(so);
                continue block2;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StateObject stateObject : statesForward) {
            if (type != HelperType.SETUP) continue;
            if (stateObject.scope == Scope.Thread) {
                for (HelperMethodInvocation mi : stateObject.getHelpers()) {
                    if (mi.helperLevel != helperLevel || mi.type != HelperType.SETUP) continue;
                    args = stateObject.helperArgs.get(mi.method.getQualifiedName());
                    arrayList.add(stateObject.localIdentifier + "." + mi.method.getName() + "(" + Utils.join(args, ",") + ");");
                }
            }
            if (stateObject.scope != Scope.Benchmark && stateObject.scope != Scope.Group) continue;
            arrayList.add("if (" + stateObject.type + ".setup" + (Object)((Object)helperLevel) + "MutexUpdater.compareAndSet(" + stateObject.localIdentifier + ", 0, 1)) {");
            arrayList.add("    try {");
            arrayList.add("        if (control.isFailing) throw new FailureAssistException();");
            arrayList.add("        if (!" + stateObject.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : stateObject.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.SETUP) continue;
                args = stateObject.helperArgs.get(mi.method.getQualifiedName());
                arrayList.add("            " + stateObject.localIdentifier + "." + mi.method.getName() + "(" + Utils.join(args, ",") + ");");
            }
            arrayList.add("            " + stateObject.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = true;");
            arrayList.add("        }");
            arrayList.add("    } catch (Throwable t) {");
            arrayList.add("        control.isFailing = true;");
            arrayList.add("        throw t;");
            arrayList.add("    } finally {");
            arrayList.add("        " + stateObject.type + ".setup" + (Object)((Object)helperLevel) + "MutexUpdater.set(" + stateObject.localIdentifier + ", 0);");
            arrayList.add("    }");
            arrayList.add("} else {");
            arrayList.add("    while (" + stateObject.type + ".setup" + (Object)((Object)helperLevel) + "MutexUpdater.get(" + stateObject.localIdentifier + ") == 1) {");
            arrayList.add("        if (control.isFailing) throw new FailureAssistException();");
            arrayList.add("        if (Thread.interrupted()) throw new InterruptedException();");
            arrayList.add("    }");
            arrayList.add("}");
        }
        for (StateObject stateObject : statesReverse) {
            if (type != HelperType.TEARDOWN) continue;
            if (stateObject.scope == Scope.Thread) {
                for (HelperMethodInvocation mi : stateObject.getHelpers()) {
                    if (mi.helperLevel != helperLevel || mi.type != HelperType.TEARDOWN) continue;
                    args = stateObject.helperArgs.get(mi.method.getQualifiedName());
                    arrayList.add(stateObject.localIdentifier + "." + mi.method.getName() + "(" + Utils.join(args, ",") + ");");
                }
            }
            if (stateObject.scope != Scope.Benchmark && stateObject.scope != Scope.Group) continue;
            arrayList.add("if (" + stateObject.type + ".tear" + (Object)((Object)helperLevel) + "MutexUpdater.compareAndSet(" + stateObject.localIdentifier + ", 0, 1)) {");
            arrayList.add("    try {");
            arrayList.add("        if (control.isFailing) throw new FailureAssistException();");
            arrayList.add("        if (" + stateObject.localIdentifier + ".ready" + (Object)((Object)helperLevel) + ") {");
            for (HelperMethodInvocation mi : stateObject.getHelpers()) {
                if (mi.helperLevel != helperLevel || mi.type != HelperType.TEARDOWN) continue;
                args = stateObject.helperArgs.get(mi.method.getQualifiedName());
                arrayList.add("            " + stateObject.localIdentifier + "." + mi.method.getName() + "(" + Utils.join(args, ",") + ");");
            }
            arrayList.add("            " + stateObject.localIdentifier + ".ready" + (Object)((Object)helperLevel) + " = false;");
            arrayList.add("        }");
            arrayList.add("    } catch (Throwable t) {");
            arrayList.add("        control.isFailing = true;");
            arrayList.add("        throw t;");
            arrayList.add("    } finally {");
            arrayList.add("        " + stateObject.type + ".tear" + (Object)((Object)helperLevel) + "MutexUpdater.set(" + stateObject.localIdentifier + ", 0);");
            arrayList.add("    }");
            arrayList.add("} else {");
            if (helperLevel == Level.Trial) {
                arrayList.add("    long " + stateObject.localIdentifier + "_backoff = 1;");
            }
            arrayList.add("    while (" + stateObject.type + ".tear" + (Object)((Object)helperLevel) + "MutexUpdater.get(" + stateObject.localIdentifier + ") == 1) {");
            if (helperLevel == Level.Trial) {
                arrayList.add("        TimeUnit.MILLISECONDS.sleep(" + stateObject.localIdentifier + "_backoff);");
                arrayList.add("        " + stateObject.localIdentifier + "_backoff = Math.max(1024, " + stateObject.localIdentifier + "_backoff * 2);");
            }
            arrayList.add("        if (control.isFailing) throw new FailureAssistException();");
            arrayList.add("        if (Thread.interrupted()) throw new InterruptedException();");
            arrayList.add("    }");
            arrayList.add("}");
        }
        return arrayList;
    }

    public boolean hasInvocationStubs(MethodInfo method) {
        return !this.getInvocationSetups(method).isEmpty() || !this.getInvocationTearDowns(method).isEmpty();
    }

    public Collection<String> getInvocationSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Invocation, HelperType.SETUP);
    }

    public Collection<String> getInvocationTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Invocation, HelperType.TEARDOWN);
    }

    public Collection<String> getIterationSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Iteration, HelperType.SETUP);
    }

    public Collection<String> getIterationTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Iteration, HelperType.TEARDOWN);
    }

    public Collection<String> getRunSetups(MethodInfo method) {
        return this.getHelperBlock(method, Level.Trial, HelperType.SETUP);
    }

    public Collection<String> getRunTearDowns(MethodInfo method) {
        return this.getHelperBlock(method, Level.Trial, HelperType.TEARDOWN);
    }

    public List<String> getStateInitializers() {
        Collection<String> args;
        Collection<StateObject> sos = StateObjectHandler.cons(this.stateObjects);
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : sos) {
            if (so.scope != Scope.Benchmark) continue;
            result.add("");
            result.add("static volatile " + so.type + " " + so.fieldIdentifier + ";");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            result.add("    " + so.type + " val = " + so.fieldIdentifier + ";");
            result.add("    if (val != null) {");
            result.add("        return val;");
            result.add("    }");
            result.add("    synchronized(this.getClass()) {");
            result.add("        try {");
            result.add("        if (control.isFailing) throw new FailureAssistException();");
            result.add("        val = " + so.fieldIdentifier + ";");
            result.add("        if (val != null) {");
            result.add("            return val;");
            result.add("        }");
            result.add("        val = new " + so.type + "();");
            if (!so.getParamsLabels().isEmpty()) {
                result.add("        Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                for (FieldInfo paramField : so.getParam(paramName)) {
                    result.add("        f = " + paramField.getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                    result.add("        f.setAccessible(true);");
                    result.add("        f.set(val, " + so.getParamAccessor(paramField) + ");");
                }
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = so.helperArgs.get(hmi.method.getQualifiedName());
                result.add("        val." + hmi.method.getName() + "(" + Utils.join(args, ",") + ");");
            }
            result.add("        val.ready" + (Object)((Object)Level.Trial) + " = true;");
            result.add("        " + so.fieldIdentifier + " = val;");
            result.add("        } catch (Throwable t) {");
            result.add("            control.isFailing = true;");
            result.add("            throw t;");
            result.add("        }");
            result.add("    }");
            result.add("    return val;");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Thread) continue;
            result.add("");
            result.add(so.type + " " + so.fieldIdentifier + ";");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            result.add("    if (control.isFailing) throw new FailureAssistException();");
            result.add("    " + so.type + " val = " + so.fieldIdentifier + ";");
            result.add("    if (val == null) {");
            result.add("        val = new " + so.type + "();");
            if (!so.getParamsLabels().isEmpty()) {
                result.add("            Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                for (FieldInfo paramField : so.getParam(paramName)) {
                    result.add("            f = " + paramField.getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                    result.add("            f.setAccessible(true);");
                    result.add("            f.set(val, " + so.getParamAccessor(paramField) + ");");
                }
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = so.helperArgs.get(hmi.method.getQualifiedName());
                result.add("        val." + hmi.method.getName() + "(" + Utils.join(args, ",") + ");");
            }
            result.add("        " + so.fieldIdentifier + " = val;");
            result.add("    }");
            result.add("    return val;");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Group) continue;
            result.add("");
            result.add("static java.util.Map<Integer, " + so.type + "> " + so.fieldIdentifier + "_map = java.util.Collections.synchronizedMap(new java.util.HashMap<Integer, " + so.type + ">());");
            result.add("");
            result.add(so.type + " _jmh_tryInit_" + so.fieldIdentifier + "(InfraControl control" + this.soDependency_TypeArgs(so) + ") throws Throwable {");
            result.add("    int groupIdx = threadParams.getGroupIndex();");
            result.add("    " + so.type + " val = " + so.fieldIdentifier + "_map.get(groupIdx);");
            result.add("    if (val != null) {");
            result.add("        return val;");
            result.add("    }");
            result.add("    synchronized(this.getClass()) {");
            result.add("        try {");
            result.add("        if (control.isFailing) throw new FailureAssistException();");
            result.add("        val = " + so.fieldIdentifier + "_map.get(groupIdx);");
            result.add("        if (val != null) {");
            result.add("            return val;");
            result.add("        }");
            result.add("        val = new " + so.type + "();");
            if (!so.getParamsLabels().isEmpty()) {
                result.add("        Field f;");
            }
            for (String paramName : so.getParamsLabels()) {
                for (FieldInfo paramField : so.getParam(paramName)) {
                    result.add("        f = " + paramField.getDeclaringClass().getQualifiedName() + ".class.getDeclaredField(\"" + paramName + "\");");
                    result.add("        f.setAccessible(true);");
                    result.add("        f.set(val, " + so.getParamAccessor(paramField) + ");");
                }
            }
            for (HelperMethodInvocation hmi : so.getHelpers()) {
                if (hmi.helperLevel != Level.Trial || hmi.type != HelperType.SETUP) continue;
                args = so.helperArgs.get(hmi.method.getQualifiedName());
                result.add("        val." + hmi.method.getName() + "(" + Utils.join(args, ",") + ");");
            }
            result.add("        val.ready" + (Object)((Object)Level.Trial) + " = true;");
            result.add("        " + so.fieldIdentifier + "_map.put(groupIdx, val);");
            result.add("        } catch (Throwable t) {");
            result.add("            control.isFailing = true;");
            result.add("            throw t;");
            result.add("        }");
            result.add("    }");
            result.add("    return val;");
            result.add("}");
        }
        return result;
    }

    private String soDependency_TypeArgs(StateObject so) {
        return so.depends.isEmpty() ? "" : ", " + this.getTypeArgList(so.depends);
    }

    private String soDependency_Args(StateObject so) {
        return so.depends.isEmpty() ? "" : ", " + this.getArgList(so.depends);
    }

    public Collection<String> getStateDestructors(MethodInfo method) {
        LinkedHashSet<StateObject> sos = this.stateOrder(method, false);
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : sos) {
            if (so.scope != Scope.Benchmark) continue;
            result.add("synchronized(this.getClass()) {");
            result.add("    " + so.fieldIdentifier + " = null;");
            result.add("}");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Thread) continue;
            result.add("" + so.fieldIdentifier + " = null;");
        }
        for (StateObject so : sos) {
            if (so.scope != Scope.Group) continue;
            result.add("synchronized(this.getClass()) {");
            result.add("    " + so.fieldIdentifier + "_map.remove(threadParams.getGroupIndex());");
            result.add("}");
        }
        return result;
    }

    public List<String> getStateGetters(MethodInfo method) {
        ArrayList<String> result = new ArrayList<String>();
        for (StateObject so : this.stateOrder(method, true)) {
            result.add(so.type + " " + so.localIdentifier + " = _jmh_tryInit_" + so.fieldIdentifier + "(control" + this.soDependency_Args(so) + ");");
        }
        return result;
    }

    private LinkedHashSet<StateObject> stateOrder(MethodInfo method, boolean reverse) {
        ArrayList linearOrder = new ArrayList();
        ArrayList<StateObject> stratum = new ArrayList<StateObject>();
        stratum.addAll(this.roots.get(method.getName()));
        stratum.addAll(this.implicits.values());
        while (!stratum.isEmpty()) {
            linearOrder.addAll(stratum);
            ArrayList<StateObject> newStratum = new ArrayList<StateObject>();
            for (StateObject so : stratum) {
                newStratum.addAll(so.depends);
            }
            stratum = newStratum;
        }
        if (reverse) {
            Collections.reverse(linearOrder);
        }
        return new LinkedHashSet<StateObject>(linearOrder);
    }

    public void writeStateOverrides(BenchmarkGeneratorSession sess, GeneratorDestination dst) throws IOException {
        for (StateObject so : StateObjectHandler.cons(this.stateObjects)) {
            if (!sess.generatedStateOverrides.add(so.userType)) continue;
            PrintWriter pw = new PrintWriter(dst.newClass(so.packageName + "." + so.type + "_B1", so.userType));
            pw.println("package " + so.packageName + ";");
            pw.println("import " + so.userType + ";");
            pw.println("public class " + so.type + "_B1 extends " + so.userType + " {");
            Paddings.padding(pw);
            pw.println("}");
            pw.close();
            pw = new PrintWriter(dst.newClass(so.packageName + "." + so.type + "_B2", so.userType));
            pw.println("package " + so.packageName + ";");
            pw.println("import " + AtomicIntegerFieldUpdater.class.getCanonicalName() + ";");
            pw.println("public class " + so.type + "_B2 extends " + so.type + "_B1 {");
            for (Level level : Level.values()) {
                pw.println("    public volatile int setup" + (Object)((Object)level) + "Mutex;");
                pw.println("    public volatile int tear" + (Object)((Object)level) + "Mutex;");
                pw.println("    public final static AtomicIntegerFieldUpdater<" + so.type + "_B2> setup" + (Object)((Object)level) + "MutexUpdater = AtomicIntegerFieldUpdater.newUpdater(" + so.type + "_B2.class, \"setup" + (Object)((Object)level) + "Mutex\");");
                pw.println("    public final static AtomicIntegerFieldUpdater<" + so.type + "_B2> tear" + (Object)((Object)level) + "MutexUpdater = AtomicIntegerFieldUpdater.newUpdater(" + so.type + "_B2.class, \"tear" + (Object)((Object)level) + "Mutex\");");
                pw.println("");
            }
            switch (so.scope) {
                case Benchmark: 
                case Group: {
                    for (Level level : Level.values()) {
                        pw.println("    public volatile boolean ready" + (Object)((Object)level) + ";");
                    }
                    break;
                }
                case Thread: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state scope: " + (Object)((Object)so.scope));
                }
            }
            pw.println("}");
            pw.close();
            pw = new PrintWriter(dst.newClass(so.packageName + "." + so.type + "_B3", so.userType));
            pw.println("package " + so.packageName + ";");
            pw.println("public class " + so.type + "_B3 extends " + so.type + "_B2 {");
            Paddings.padding(pw);
            pw.println("}");
            pw.println("");
            pw.close();
            pw = new PrintWriter(dst.newClass(so.packageName + "." + so.type, so.userType));
            pw.println("package " + so.packageName + ";");
            pw.println("public class " + so.type + " extends " + so.type + "_B3 {");
            pw.println("}");
            pw.println("");
            pw.close();
        }
    }

    public Collection<String> getFields() {
        return Collections.emptyList();
    }

    public StateObject getImplicit(String label) {
        return this.implicits.get(label);
    }

    public void addImports(PrintWriter writer) {
        for (StateObject so : StateObjectHandler.cons(this.stateObjects)) {
            writer.println("import " + so.packageName + "." + so.type + ";");
        }
    }

    public Collection<String> getAuxResets(MethodInfo method) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.auxNames.get(method.getName())) {
            if (!this.auxResettable.get(name).booleanValue()) continue;
            result.add(this.auxAccessors.get(method.getName() + name) + " = 0;");
        }
        return result;
    }

    public Collection<String> getAuxResults(MethodInfo method, String opResName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String ops : this.auxNames.get(method.getName())) {
            AuxCounters.Type type = this.auxType.get(ops);
            block0 : switch (type) {
                case OPERATIONS: {
                    switch (opResName) {
                        case "ThroughputResult": 
                        case "AverageTimeResult": {
                            result.add("new " + opResName + "(ResultRole.SECONDARY, \"" + ops + "\", " + this.auxAccessors.get(method.getName() + ops) + ", res.getTime(), benchmarkParams.getTimeUnit())");
                            break block0;
                        }
                        case "SampleTimeResult": 
                        case "SingleShotResult": {
                            break block0;
                        }
                    }
                    throw new GenerationException("Unknown result name for @" + AuxCounters.class + ": " + opResName, method);
                }
                case EVENTS: {
                    result.add("new ScalarResult(\"" + ops + "\", " + this.auxAccessors.get(method.getName() + ops) + ", \"#\", AggregationPolicy.SUM)");
                    break;
                }
                default: {
                    throw new GenerationException("Unknown @" + AuxCounters.class + " type: " + (Object)((Object)type), method);
                }
            }
        }
        return result;
    }

    private static class ClassQName {
        private final ClassInfo ci;

        private ClassQName(ClassInfo ci) {
            this.ci = ci;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassQName cycleInfo = (ClassQName)o;
            return Objects.equals(this.ci.getQualifiedName(), cycleInfo.ci.getQualifiedName());
        }

        public int hashCode() {
            return Objects.hash(this.ci.getQualifiedName());
        }
    }
}

