/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;

public class RunResult
implements Serializable {
    private static final long serialVersionUID = 6467912427356048369L;
    private final Collection<BenchmarkResult> benchmarkResults;
    private final BenchmarkParams params;
    public static final Comparator<RunResult> DEFAULT_SORT_COMPARATOR = new Comparator<RunResult>(){

        @Override
        public int compare(RunResult o1, RunResult o2) {
            return o1.params.compareTo(o2.params);
        }
    };

    public RunResult(BenchmarkParams params, Collection<BenchmarkResult> data) {
        this.benchmarkResults = data;
        this.params = params;
    }

    public Collection<BenchmarkResult> getBenchmarkResults() {
        return this.benchmarkResults;
    }

    public Result getPrimaryResult() {
        return this.getAggregatedResult().getPrimaryResult();
    }

    public Map<String, Result> getSecondaryResults() {
        return this.getAggregatedResult().getSecondaryResults();
    }

    public BenchmarkResult getAggregatedResult() {
        if (this.benchmarkResults.isEmpty()) {
            return null;
        }
        ArrayList<IterationResult> results = new ArrayList<IterationResult>();
        for (BenchmarkResult r : this.benchmarkResults) {
            results.addAll(r.getIterationResults());
        }
        BenchmarkResult result = new BenchmarkResult(this.params, results);
        for (BenchmarkResult br : this.benchmarkResults) {
            for (String k : br.getBenchmarkResults().keys()) {
                for (Result r : br.getBenchmarkResults().get(k)) {
                    result.addBenchmarkResult(r);
                }
            }
        }
        return result;
    }

    public BenchmarkParams getParams() {
        return this.params;
    }
}

