/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.Event;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeParseEventException;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StrictMimeTokenStreamTest {
    private static final String HEADER_ONLY = "From: foo@abr.com\r\nSubject: A subject\r\n";
    private static final String CORRECT_HEADERS = "From: foo@abr.com\r\nSubject: A subject\r\n\r\n";
    MimeTokenStream parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MimeTokenStream(MimeConfig.STRICT);
    }

    @Test
    public void testUnexpectedEndOfHeaders() throws Exception {
        this.parser.parse((InputStream)new ByteArrayInputStream(HEADER_ONLY.getBytes("US-ASCII")));
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        try {
            this.parser.next();
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (MimeParseEventException e) {
            Assert.assertEquals((String)"Premature end of headers", (Object)Event.HEADERS_PREMATURE_END, (Object)e.getEvent());
        }
    }

    @Test
    public void testCorrectEndOfHeaders() throws Exception {
        this.parser.parse((InputStream)new ByteArrayInputStream(CORRECT_HEADERS.getBytes("US-ASCII")));
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
    }

    @Test
    public void testMissingBoundary() throws Exception {
        String message = "Content-Type: multipart/mixed;boundary=aaaa\r\n\r\n--aaaa\r\nContent-Type:text/plain; charset=US-ASCII\r\n\r\nOh my god! Boundary is missing!\r\n";
        this.parser.parse((InputStream)new ByteArrayInputStream(message.getBytes("US-ASCII")));
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_START_MULTIPART);
        this.checkNextIs(EntityState.T_START_BODYPART);
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_BODY);
        InputStream in = this.parser.getInputStream();
        StringBuilder sb = new StringBuilder();
        try {
            int l;
            byte[] tmp = new byte[1024];
            while ((l = in.read(tmp)) != -1) {
                sb.append(new String(tmp, 0, l, "US-ASCII"));
            }
            Assert.fail((String)"MimeIOException should have been thrown");
        }
        catch (MimeIOException expected) {
            Assert.assertEquals((Object)"Oh my god! Boundary is missing!\r\n", (Object)sb.toString());
        }
    }

    private void checkNextIs(EntityState expected) throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)expected), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
    }
}

