/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.QuitHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuitCmdHandler
extends AbstractHookableCmdHandler<QuitHook> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuitCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"QUIT");
    private static final Response SYNTAX_ERROR;

    @Inject
    public QuitCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    private Response doQUIT(SMTPSession session, String argument) {
        if (argument == null || argument.length() == 0) {
            StringBuilder response = new StringBuilder();
            response.append(DSNStatus.getStatus(2, "0.0")).append(" ").append(session.getConfiguration().getHelloName()).append(" Service closing transmission channel");
            SMTPResponse ret = new SMTPResponse("221", response);
            ret.setEndSession(true);
            LOGGER.debug("QUIT");
            return ret;
        }
        return SYNTAX_ERROR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doQUIT(session, parameters);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        return null;
    }

    @Override
    protected Class<QuitHook> getHookInterface() {
        return QuitHook.class;
    }

    @Override
    protected HookResult callHook(QuitHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doQuit(session);
    }

    static {
        SMTPResponse response = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with QUIT command");
        response.setEndSession(true);
        SYNTAX_ERROR = response.immutable();
    }
}

