/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail.model;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.StringBackedAttachmentId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

@Entity(name="Attachment")
@Table(name="JAMES_ATTACHMENT")
@NamedQuery(name="findAttachmentById", query="SELECT attachment FROM Attachment attachment WHERE attachment.attachmentId = :idParam")
public class JPAAttachment
implements PersistenceCapable {
    private static final String TOSTRING_SEPARATOR = " ";
    private static final byte[] EMPTY_ARRAY = new byte[0];
    @Id
    @GeneratedValue
    @Column(name="ATTACHMENT_ID", nullable=false)
    private String attachmentId;
    @Basic(optional=false)
    @Column(name="TYPE", nullable=false)
    private String type;
    @Basic(optional=false)
    @Column(name="SIZE", nullable=false)
    private long size;
    @Basic(optional=false, fetch=FetchType.LAZY)
    @Column(name="CONTENT", length=1048576000, nullable=false)
    @Lob
    private byte[] content;
    @Basic(optional=true)
    @Column(name="NAME")
    private String name;
    @Basic(optional=true)
    @Column(name="CID")
    private String cid;
    @Basic(optional=false)
    @Column(name="INLINE", nullable=false)
    private boolean isInline;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    public JPAAttachment() {
    }

    public JPAAttachment(MessageAttachmentMetadata messageAttachmentMetadata, byte[] bytes) {
        this.setMetadata(messageAttachmentMetadata, bytes);
    }

    public JPAAttachment(MessageAttachmentMetadata messageAttachmentMetadata) {
        this.setMetadata(messageAttachmentMetadata, new byte[0]);
    }

    private void setMetadata(MessageAttachmentMetadata messageAttachmentMetadata, byte[] bytes) {
        JPAAttachment.pcSetname(this, messageAttachmentMetadata.getName().orElse(null));
        messageAttachmentMetadata.getCid().ifPresentOrElse(c -> JPAAttachment.pcSetcid(this, c.getValue()), () -> JPAAttachment.pcSetcid(this, ""));
        JPAAttachment.pcSettype(this, messageAttachmentMetadata.getAttachment().getType().asString());
        JPAAttachment.pcSetsize(this, messageAttachmentMetadata.getAttachment().getSize());
        JPAAttachment.pcSetisInline(this, messageAttachmentMetadata.isInline());
        JPAAttachment.pcSetcontent(this, bytes);
    }

    public AttachmentMetadata toAttachmentMetadata() {
        return AttachmentMetadata.builder().attachmentId((AttachmentId)StringBackedAttachmentId.from((String)JPAAttachment.pcGetattachmentId(this))).messageId((MessageId)new DefaultMessageId()).type(JPAAttachment.pcGettype(this)).size(JPAAttachment.pcGetsize(this)).build();
    }

    public MessageAttachmentMetadata toMessageAttachmentMetadata() {
        return MessageAttachmentMetadata.builder().attachment(this.toAttachmentMetadata()).name(Optional.ofNullable(JPAAttachment.pcGetname(this))).cid(Optional.of(Cid.from((String)JPAAttachment.pcGetcid(this)))).isInline(Boolean.valueOf(JPAAttachment.pcGetisInline(this))).build();
    }

    public String getAttachmentId() {
        return JPAAttachment.pcGetattachmentId(this);
    }

    public String getType() {
        return JPAAttachment.pcGettype(this);
    }

    public long getSize() {
        return JPAAttachment.pcGetsize(this);
    }

    public String getName() {
        return JPAAttachment.pcGetname(this);
    }

    public boolean isInline() {
        return JPAAttachment.pcGetisInline(this);
    }

    public String getCid() {
        return JPAAttachment.pcGetcid(this);
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(Objects.requireNonNullElse(JPAAttachment.pcGetcontent(this), EMPTY_ARRAY));
    }

    public void setType(String type) {
        JPAAttachment.pcSettype(this, type);
    }

    public void setSize(long size) {
        JPAAttachment.pcSetsize(this, size);
    }

    public void setContent(byte[] bytes) {
        JPAAttachment.pcSetcontent(this, bytes);
    }

    public String toString() {
        return "Attachment ( attachmentId = " + JPAAttachment.pcGetattachmentId(this) + " name = " + JPAAttachment.pcGettype(this) + " type = " + JPAAttachment.pcGettype(this) + " size = " + JPAAttachment.pcGetsize(this) + " cid = " + JPAAttachment.pcGetcid(this) + " isInline = " + JPAAttachment.pcGetisInline(this) + "  )";
    }

    public final boolean equals(Object o) {
        if (o instanceof JPAAttachment) {
            JPAAttachment that = (JPAAttachment)o;
            return Objects.equals(JPAAttachment.pcGetsize(this), JPAAttachment.pcGetsize(that)) && Objects.equals(JPAAttachment.pcGetattachmentId(this), JPAAttachment.pcGetattachmentId(that)) && Objects.equals(JPAAttachment.pcGetcid(this), JPAAttachment.pcGetcid(that)) && Arrays.equals(JPAAttachment.pcGetcontent(this), JPAAttachment.pcGetcontent(that)) && Objects.equals(JPAAttachment.pcGetisInline(this), JPAAttachment.pcGetisInline(that)) && Objects.equals(JPAAttachment.pcGetname(this), JPAAttachment.pcGetname(that)) && Objects.equals(JPAAttachment.pcGettype(this), JPAAttachment.pcGettype(that));
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(JPAAttachment.pcGetattachmentId(this), JPAAttachment.pcGettype(this), JPAAttachment.pcGetsize(this), JPAAttachment.pcGetname(this), JPAAttachment.pcGetcid(this), JPAAttachment.pcGetisInline(this));
    }

    static {
        pcFieldNames = new String[]{"attachmentId", "cid", "content", "isInline", "name", "size", "type"};
        pcFieldTypes = new Class[]{String.class, String.class, byte[].class, Boolean.TYPE, String.class, Long.TYPE, String.class};
        pcFieldFlags = new byte[]{26, 26, 21, 26, 26, 26, 26};
        PCRegistry.register(JPAAttachment.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Attachment", (PersistenceCapable)new JPAAttachment());
    }

    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    protected void pcClearFields() {
        this.attachmentId = null;
        this.cid = null;
        this.content = null;
        this.isInline = false;
        this.name = null;
        this.size = 0L;
        this.type = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAttachment jPAAttachment = new JPAAttachment();
        if (bl) {
            jPAAttachment.pcClearFields();
        }
        jPAAttachment.pcStateManager = stateManager;
        jPAAttachment.pcCopyKeyFieldsFromObjectId(object);
        return jPAAttachment;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAttachment jPAAttachment = new JPAAttachment();
        if (bl) {
            jPAAttachment.pcClearFields();
        }
        jPAAttachment.pcStateManager = stateManager;
        return jPAAttachment;
    }

    protected static int pcGetManagedFieldCount() {
        return 7;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attachmentId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.cid = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.content = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.isInline = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.size = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.type = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.attachmentId);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.cid);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.content);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.isInline);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 5: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.size);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAttachment jPAAttachment, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attachmentId = jPAAttachment.attachmentId;
                return;
            }
            case 1: {
                this.cid = jPAAttachment.cid;
                return;
            }
            case 2: {
                this.content = jPAAttachment.content;
                return;
            }
            case 3: {
                this.isInline = jPAAttachment.isInline;
                return;
            }
            case 4: {
                this.name = jPAAttachment.name;
                return;
            }
            case 5: {
                this.size = jPAAttachment.size;
                return;
            }
            case 6: {
                this.type = jPAAttachment.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAAttachment jPAAttachment = (JPAAttachment)object;
        if (jPAAttachment.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAttachment, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.attachmentId = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new StringId(JPAAttachment.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new StringId(JPAAttachment.class, this.attachmentId);
    }

    private static final String pcGetattachmentId(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.attachmentId;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.attachmentId;
    }

    private static final void pcSetattachmentId(JPAAttachment jPAAttachment, String string) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.attachmentId = string;
            return;
        }
        jPAAttachment.pcStateManager.settingStringField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 0, jPAAttachment.attachmentId, string, 0);
    }

    private static final String pcGetcid(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.cid;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.cid;
    }

    private static final void pcSetcid(JPAAttachment jPAAttachment, String string) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.cid = string;
            return;
        }
        jPAAttachment.pcStateManager.settingStringField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 1, jPAAttachment.cid, string, 0);
    }

    private static final byte[] pcGetcontent(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.content;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.content;
    }

    private static final void pcSetcontent(JPAAttachment jPAAttachment, byte[] byArray) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.content = byArray;
            return;
        }
        jPAAttachment.pcStateManager.settingObjectField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 2, (Object)jPAAttachment.content, (Object)byArray, 0);
    }

    private static final boolean pcGetisInline(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.isInline;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.isInline;
    }

    private static final void pcSetisInline(JPAAttachment jPAAttachment, boolean bl) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.isInline = bl;
            return;
        }
        jPAAttachment.pcStateManager.settingBooleanField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 3, jPAAttachment.isInline, bl, 0);
    }

    private static final String pcGetname(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.name;
        }
        int n = pcInheritedFieldCount + 4;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.name;
    }

    private static final void pcSetname(JPAAttachment jPAAttachment, String string) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.name = string;
            return;
        }
        jPAAttachment.pcStateManager.settingStringField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 4, jPAAttachment.name, string, 0);
    }

    private static final long pcGetsize(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.size;
        }
        int n = pcInheritedFieldCount + 5;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.size;
    }

    private static final void pcSetsize(JPAAttachment jPAAttachment, long l) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.size = l;
            return;
        }
        jPAAttachment.pcStateManager.settingLongField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 5, jPAAttachment.size, l, 0);
    }

    private static final String pcGettype(JPAAttachment jPAAttachment) {
        if (jPAAttachment.pcStateManager == null) {
            return jPAAttachment.type;
        }
        int n = pcInheritedFieldCount + 6;
        jPAAttachment.pcStateManager.accessingField(n);
        return jPAAttachment.type;
    }

    private static final void pcSettype(JPAAttachment jPAAttachment, String string) {
        if (jPAAttachment.pcStateManager == null) {
            jPAAttachment.type = string;
            return;
        }
        jPAAttachment.pcStateManager.settingStringField((PersistenceCapable)jPAAttachment, pcInheritedFieldCount + 6, jPAAttachment.type, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.attachmentId != null && !"".equals(this.attachmentId)) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

