/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages.haddock;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.time.Duration;
import org.apache.wiki.pages.Page;
import org.apache.wiki.pages.haddock.EditWikiPage;
import org.apache.wiki.pages.haddock.HaddockPage;
import org.apache.wiki.pages.haddock.LoginPage;
import org.apache.wiki.pages.haddock.SearchResultsPage;
import org.openqa.selenium.By;

public class ViewWikiPage
implements HaddockPage {
    public static ViewWikiPage open(String pageName) {
        return Page.withUrl(Page.baseUrl() + "/Wiki.jsp?page=" + pageName).openAs(new ViewWikiPage());
    }

    public String authenticatedText() {
        return Selenide.$((By)By.className((String)"wikipage")).text().trim();
    }

    public LoginPage clickOnLogin() {
        this.hoverLoginArea();
        Selenide.$((By)By.className((String)"icon-signin")).click();
        return new LoginPage();
    }

    public ViewWikiPage clickOnShowReaderView() {
        Selenide.$((By)By.linkText((String)"Show Reader View")).click();
        return this;
    }

    public ViewWikiPage hoverLoginArea() {
        Selenide.$((By)By.className((String)"icon-user")).hover();
        return this;
    }

    public ViewWikiPage hoverMoreArea() {
        Selenide.$((By)By.id((String)"more")).hover();
        return this;
    }

    public EditWikiPage editPage() {
        Selenide.$((By)By.cssSelector((String)"li#edit a")).shouldBe(Condition.visible, Duration.ofSeconds(1L)).click();
        return new EditWikiPage();
    }

    public SearchResultsPage searchFor(String text) {
        Selenide.$((By)By.className((String)"icon-search")).hover();
        Selenide.$((By)By.id((String)"query")).click();
        Selenide.$((By)By.id((String)"query")).val(text);
        Selenide.$((By)By.id((String)"searchSubmit")).click();
        return new SearchResultsPage();
    }

    public ViewWikiPage clickOnLogout() {
        this.hoverLoginArea();
        Selenide.$((By)By.linkText((String)"Log out")).click();
        Selenide.$((By)By.className((String)"btn-success")).shouldBe(Condition.visible, Duration.ofSeconds(1L)).click();
        return this;
    }

    public ViewWikiPage navigateTo(String wikiPageName) {
        Selenide.$((By)By.linkText((String)wikiPageName)).click();
        return this;
    }

    public SelenideElement sidebar() {
        return Selenide.$((By)By.className((String)"sidebar"));
    }
}

