/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.internal.StringUtils;

@Header(type="integer", format="int32")
public class BasicIntegerHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private Integer parsed;

    public static BasicIntegerHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicIntegerHeader(name, value);
    }

    public static BasicIntegerHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicIntegerHeader(name, value);
    }

    public BasicIntegerHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.asInt());
    }

    public Integer asInt() {
        return this.getParsedValue();
    }

    public FluentIntegerAssertion<BasicIntegerHeader> assertInteger() {
        return new FluentIntegerAssertion<BasicIntegerHeader>(this.asInt(), this);
    }

    private Integer getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String s = o.toString();
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(s);
                return Integer.MAX_VALUE;
            }
            catch (NumberFormatException e2) {
                throw new BasicIllegalArgumentException("Value could not be parsed as an int: {0}", o);
            }
        }
    }
}

