/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ClassUtils;

public class HtmlClassMeta
extends ExtendedClassMeta {
    private final List<Html> htmls;
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender<?> render;

    public HtmlClassMeta(ClassMeta<?> cm, HtmlMetaProvider mp) {
        super(cm);
        this.htmls = cm.getAnnotations(Html.class);
        boolean _noTables = false;
        boolean _noTableHeaders = false;
        HtmlRender _render = null;
        HtmlFormat _format = HtmlFormat.HTML;
        for (Html a : this.htmls) {
            _format = a.format();
            _noTables = a.noTables();
            _noTableHeaders = a.noTableHeaders();
            _render = ClassUtils.castOrCreate(HtmlRender.class, a.render());
        }
        this.noTables = _noTables;
        this.noTableHeaders = _noTableHeaders;
        this.render = _render;
        this.format = _format;
    }

    protected List<Html> getAnnotations() {
        return this.htmls;
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender<?> getRender() {
        return this.render;
    }
}

