/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.BasicHttpEntity;
import org.apache.juneau.http.HttpResource;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.ObjectUtils;

public class BasicHttpResource
extends BasicHttpEntity
implements HttpResource {
    private final List<Header> headers = AList.of();

    public static BasicHttpResource of(Object content) {
        return new BasicHttpResource(content);
    }

    public static BasicHttpResource of(Supplier<?> content) {
        return new BasicHttpResource(content);
    }

    public BasicHttpResource(Object content) {
        super(content);
    }

    public BasicHttpResource(Object content, ContentType contentType, ContentEncoding contentEncoding) {
        super(content, contentType, contentEncoding);
    }

    @FluentSetter
    public BasicHttpResource header(String name, Object val) {
        if (name != null && val != null) {
            this.headers.add(BasicHeader.of(name, val));
        }
        return this;
    }

    @FluentSetter
    public BasicHttpResource header(Header value) {
        this.headers.add(value);
        return this;
    }

    @FluentSetter
    public BasicHttpResource headers(List<Header> headers) {
        this.headers.addAll(headers);
        return this;
    }

    @FluentSetter
    public BasicHttpResource headers(Header ... headers) {
        this.headers.addAll(Arrays.asList(headers));
        return this;
    }

    public String getStringHeader(String name) {
        Header h = this.getLastHeader(name);
        return h == null ? null : h.getValue();
    }

    public Header getFirstHeader(String name) {
        for (Header h : this.headers) {
            if (h == null || !ObjectUtils.eq(name, h.getName())) continue;
            return h;
        }
        return null;
    }

    public Header getLastHeader(String name) {
        ListIterator<Header> li = this.headers.listIterator(this.headers.size());
        while (li.hasPrevious()) {
            Header h = li.previous();
            if (h == null || !ObjectUtils.eq(name, h.getName())) continue;
            return h;
        }
        return null;
    }

    @Override
    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    @Override
    public BasicHttpResource cache() {
        super.cache();
        return this;
    }

    @Override
    public BasicHttpResource cache(boolean value) {
        super.cache(value);
        return this;
    }

    @Override
    public BasicHttpResource chunked() {
        super.chunked();
        return this;
    }

    @Override
    public BasicHttpResource chunked(boolean value) {
        super.chunked(value);
        return this;
    }

    @Override
    public BasicHttpResource contentEncoding(String value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public BasicHttpResource contentEncoding(Header value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public BasicHttpResource contentLength(long value) {
        super.contentLength(value);
        return this;
    }

    @Override
    public BasicHttpResource contentType(String value) {
        super.contentType(value);
        return this;
    }

    @Override
    public BasicHttpResource contentType(Header value) {
        super.contentType(value);
        return this;
    }
}

