/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.reflect.MethodInfo;

public class RdfAnnotation
implements Rdf {
    private String on = "";
    private String namespace = "";
    private String prefix = "";
    private boolean beanUri = false;
    private RdfCollectionFormat collectionFormat = RdfCollectionFormat.DEFAULT;

    public RdfAnnotation(String on) {
        this.on(on);
    }

    public RdfAnnotation(Class<?> on) {
        this.on(on);
    }

    public RdfAnnotation(Method on) {
        this.on(on);
    }

    public RdfAnnotation(Field on) {
        this.on(on);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Rdf.class;
    }

    @Override
    public boolean beanUri() {
        return this.beanUri;
    }

    public RdfAnnotation beanUri(boolean value) {
        this.beanUri = value;
        return this;
    }

    @Override
    public RdfCollectionFormat collectionFormat() {
        return this.collectionFormat;
    }

    public RdfAnnotation collectionFormat(RdfCollectionFormat value) {
        this.collectionFormat = value;
        return this;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    public RdfAnnotation namespace(String value) {
        this.namespace = value;
        return this;
    }

    @Override
    public String on() {
        return this.on;
    }

    public RdfAnnotation on(String value) {
        this.on = value;
        return this;
    }

    public RdfAnnotation on(Class<?> value) {
        this.on = value.getName();
        return this;
    }

    public RdfAnnotation on(Method value) {
        this.on = MethodInfo.of((Method)value).getFullName();
        return this;
    }

    public RdfAnnotation on(Field value) {
        this.on = value.getName();
        return this;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    public RdfAnnotation prefix(String value) {
        this.prefix = value;
        return this;
    }
}

