/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard.tracker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

public final class ServletContextHelperTracker
extends ServiceTracker<ServletContextHelper, ServiceReference<ServletContextHelper>> {
    private final WhiteboardManager contextManager;
    private final Map<Long, ServletContextHelperInfo> allInfos = new ConcurrentHashMap<Long, ServletContextHelperInfo>();

    private static Filter createFilter(BundleContext btx) {
        try {
            return btx.createFilter(String.format("(objectClass=%s)", ServletContextHelper.class.getName()));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public ServletContextHelperTracker(@Nonnull BundleContext context, @Nonnull WhiteboardManager manager) {
        super(context, ServletContextHelperTracker.createFilter(context), null);
        this.contextManager = manager;
    }

    public void close() {
        super.close();
        this.allInfos.clear();
    }

    public final ServiceReference<ServletContextHelper> addingService(@Nonnull ServiceReference<ServletContextHelper> ref) {
        this.added(ref);
        return ref;
    }

    public final void modifiedService(@Nonnull ServiceReference<ServletContextHelper> ref, @Nonnull ServiceReference<ServletContextHelper> service) {
        this.removed(ref);
        this.added(ref);
    }

    public final void removedService(@Nonnull ServiceReference<ServletContextHelper> ref, @Nonnull ServiceReference<ServletContextHelper> service) {
        this.removed(ref);
    }

    private void added(@Nonnull ServiceReference<ServletContextHelper> ref) {
        ServletContextHelperInfo info = new ServletContextHelperInfo(ref);
        if (this.contextManager.addContextHelper(info)) {
            this.allInfos.put((Long)ref.getProperty("service.id"), info);
        }
    }

    private void removed(@Nonnull ServiceReference<ServletContextHelper> ref) {
        ServletContextHelperInfo info = this.allInfos.get(ref.getProperty("service.id"));
        if (info != null) {
            this.contextManager.removeContextHelper(info);
        }
    }
}

