/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import org.apache.karaf.features.internal.model.Features;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private JacksonUtil() {
    }

    public static boolean isJson(String uri) {
        try {
            return JacksonUtil.isJson(new URL(uri).openStream());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJson(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("{")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    public static Features unmarshal(String uri) throws IOException {
        return JacksonUtil.unmarshal(new URL(uri).openStream());
    }

    public static Features unmarshal(InputStream inputStream) throws IOException {
        return mapper.readValue(inputStream, Features.class);
    }

    public static void marshal(Features features, OutputStream outputStream) throws IOException {
        mapper.writeValue(outputStream, (Object)features);
    }

    public static void marshal(Features features, Writer writer) throws IOException {
        mapper.writeValue(writer, (Object)features);
    }
}

