/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;

public class ColorPanel
extends JPanel {
    private static final String DEFAULT_STATUS = "<html>Double click a rule field to edit the rule</html>";
    private final String currentRuleSet = "Default";
    private RuleColorizer colorizer;
    private JPanel rulesPanel;
    private FilterModel filterModel;
    private DefaultTableModel tableModel;
    private JScrollPane tableScrollPane;
    private JTable table;
    private ActionListener closeListener;
    private JLabel statusBar;
    private Vector<String> columns;
    private final String noTab = "None";
    private DefaultComboBoxModel logPanelColorizersModel;
    private Map<String, RuleColorizer> allLogPanelColorizers;
    private RuleColorizer currentLogPanelColorizer;
    private JTable searchTable;
    private DefaultTableModel searchTableModel;
    private Vector<String> searchColumns;
    private Vector<Vector<Color>> searchDataVector;
    private Vector<Color> searchDataVectorEntry;
    private JTable alternatingColorTable;
    private DefaultTableModel alternatingColorTableModel;
    private Vector<String> alternatingColorColumns;
    private Vector<Vector<Color>> alternatingColorDataVector;
    private Vector<Color> alternatingColorDataVectorEntry;
    private ApplicationPreferenceModel applicationPreferenceModel;
    private JCheckBox bypassSearchColorsCheckBox;

    public ColorPanel(RuleColorizer currentLogPanelColorizer, FilterModel filterModel, final Map<String, RuleColorizer> allLogPanelColorizers, ApplicationPreferenceModel applicationPreferenceModel) {
        super(new BorderLayout());
        this.currentLogPanelColorizer = currentLogPanelColorizer;
        this.colorizer = currentLogPanelColorizer;
        this.filterModel = filterModel;
        this.allLogPanelColorizers = allLogPanelColorizers;
        this.applicationPreferenceModel = applicationPreferenceModel;
        currentLogPanelColorizer.addPropertyChangeListener("colorrule", evt -> this.updateColors());
        this.tableModel = new DefaultTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(20);
        this.searchTableModel = new DefaultTableModel();
        this.searchTable = new JTable(this.searchTableModel);
        this.searchTable.setRowHeight(20);
        this.searchTable.setPreferredScrollableViewportSize(new Dimension(30, 30));
        this.alternatingColorTableModel = new DefaultTableModel();
        this.alternatingColorTable = new JTable(this.alternatingColorTableModel);
        this.alternatingColorTable.setRowHeight(20);
        this.alternatingColorTable.setPreferredScrollableViewportSize(new Dimension(30, 30));
        this.columns = new Vector();
        this.columns.add("Expression");
        this.columns.add("Background");
        this.columns.add("Foreground");
        this.searchColumns = new Vector();
        this.searchColumns.add("Background");
        this.searchColumns.add("Foreground");
        this.alternatingColorColumns = new Vector();
        this.alternatingColorColumns.add("Background");
        this.alternatingColorColumns.add("Foreground");
        this.searchDataVector = new Vector();
        this.searchDataVectorEntry = new Vector();
        this.searchDataVectorEntry.add(applicationPreferenceModel.getSearchBackgroundColor());
        this.searchDataVectorEntry.add(applicationPreferenceModel.getSearchForegroundColor());
        this.searchDataVector.add(this.searchDataVectorEntry);
        this.searchTableModel.setDataVector(this.searchDataVector, this.searchColumns);
        this.alternatingColorDataVector = new Vector();
        this.alternatingColorDataVectorEntry = new Vector();
        this.alternatingColorDataVectorEntry.add(applicationPreferenceModel.getAlternatingColorBackgroundColor());
        this.alternatingColorDataVectorEntry.add(applicationPreferenceModel.getAlternatingColorForegroundColor());
        this.alternatingColorDataVector.add(this.alternatingColorDataVectorEntry);
        this.alternatingColorTableModel.setDataVector(this.alternatingColorDataVector, this.alternatingColorColumns);
        this.table.setPreferredScrollableViewportSize(new Dimension(525, 200));
        this.tableScrollPane = new JScrollPane(this.table);
        Vector<Vector<Serializable>> data = this.getColorizerVector();
        this.tableModel.setDataVector(data, this.columns);
        this.table.sizeColumnsToFit(0);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setMaxWidth(80);
        this.table.getColumnModel().getColumn(2).setMaxWidth(80);
        this.searchTable.sizeColumnsToFit(0);
        this.searchTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.searchTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.searchTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.searchTable.getColumnModel().getColumn(1).setMaxWidth(80);
        SwingHelper.invokeOnEDT(() -> this.configureSingleEntryColorTable(this.searchTable));
        this.alternatingColorTable.sizeColumnsToFit(0);
        this.alternatingColorTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.alternatingColorTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.alternatingColorTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.alternatingColorTable.getColumnModel().getColumn(1).setMaxWidth(80);
        SwingHelper.invokeOnEDT(() -> this.configureSingleEntryColorTable(this.alternatingColorTable));
        this.configureTable();
        this.statusBar = new JLabel(DEFAULT_STATUS);
        this.rulesPanel = this.buildRulesPanel();
        this.rulesPanel.setAlignmentX(0.0f);
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel rightOuterPanel = new JPanel();
        rightOuterPanel.setLayout(new BoxLayout(rightOuterPanel, 0));
        rightOuterPanel.add(Box.createHorizontalStrut(10));
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        southPanel.add(Box.createVerticalStrut(5));
        southPanel.add(Box.createVerticalStrut(5));
        JPanel searchAndAlternatingColorPanel = this.buildSearchAndAlternatingColorPanel();
        JPanel bypassSearchColorsPanel = this.buildBypassSearchColorsPanel();
        this.bypassSearchColorsCheckBox.setSelected(applicationPreferenceModel.isBypassSearchColors());
        JPanel globalLabelPanel = new JPanel();
        globalLabelPanel.setLayout(new BoxLayout(globalLabelPanel, 0));
        JLabel globalLabel = new JLabel("Global colors:");
        globalLabelPanel.add(globalLabel);
        globalLabelPanel.add(Box.createHorizontalGlue());
        southPanel.add(globalLabelPanel);
        southPanel.add(searchAndAlternatingColorPanel);
        southPanel.add(bypassSearchColorsPanel);
        southPanel.add(Box.createVerticalStrut(5));
        JPanel closePanel = this.buildClosePanel();
        southPanel.add(closePanel);
        JPanel statusPanel = new JPanel(new FlowLayout(0));
        statusPanel.add(this.statusBar);
        southPanel.add(statusPanel);
        rightPanel.add((Component)this.rulesPanel, "Center");
        rightPanel.add((Component)southPanel, "South");
        rightOuterPanel.add(rightPanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JLabel selectText = new JLabel("Apply a tab's colors");
        topPanel.add(selectText);
        topPanel.add(Box.createHorizontalStrut(5));
        this.logPanelColorizersModel = new DefaultComboBoxModel();
        final JComboBox loadPanelColorizersComboBox = new JComboBox(this.logPanelColorizersModel);
        this.loadLogPanelColorizers();
        topPanel.add(loadPanelColorizersComboBox);
        topPanel.add(Box.createHorizontalStrut(5));
        AbstractAction copyRulesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.tableModel.getDataVector().clear();
                Object selectedItem = loadPanelColorizersComboBox.getSelectedItem();
                if (selectedItem != null) {
                    RuleColorizer sourceColorizer = (RuleColorizer)allLogPanelColorizers.get(selectedItem.toString());
                    ColorPanel.this.colorizer.setRules(sourceColorizer.getRules());
                    ColorPanel.this.updateColors();
                }
            }
        };
        loadPanelColorizersComboBox.addActionListener(e -> {
            Object selectedItem = loadPanelColorizersComboBox.getSelectedItem();
            if (selectedItem != null) {
                String selectedColorizerName = selectedItem.toString();
                copyRulesAction.setEnabled(!"None".equals(selectedColorizerName));
            }
        });
        copyRulesAction.putValue("Name", "Copy color rules");
        copyRulesAction.setEnabled(!"None".equals(loadPanelColorizersComboBox.getSelectedItem()));
        JButton copyRulesButton = new JButton(copyRulesAction);
        topPanel.add(copyRulesButton);
        this.add((Component)topPanel, "North");
        this.add((Component)rightOuterPanel, "Center");
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void loadLogPanelColorizers() {
        if (this.logPanelColorizersModel.getIndexOf("None") == -1) {
            this.logPanelColorizersModel.addElement("None");
        }
        for (Map.Entry<String, RuleColorizer> o : this.allLogPanelColorizers.entrySet()) {
            Map.Entry<String, RuleColorizer> entry = o;
            if (entry.getValue().equals(this.currentLogPanelColorizer) || this.logPanelColorizersModel.getIndexOf(entry.getKey()) != -1) continue;
            this.logPanelColorizersModel.addElement(entry.getKey());
        }
        this.searchDataVectorEntry.set(0, this.applicationPreferenceModel.getSearchBackgroundColor());
        this.searchDataVectorEntry.set(1, this.applicationPreferenceModel.getSearchForegroundColor());
        this.alternatingColorDataVectorEntry.set(0, this.applicationPreferenceModel.getAlternatingColorBackgroundColor());
        this.alternatingColorDataVectorEntry.set(1, this.applicationPreferenceModel.getAlternatingColorForegroundColor());
    }

    public JPanel buildBypassSearchColorsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.bypassSearchColorsCheckBox = new JCheckBox("Don't use a search color for matching rows");
        panel.add(this.bypassSearchColorsCheckBox);
        return panel;
    }

    public JPanel buildSearchAndAlternatingColorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel defineSearchColorsLabel = new JLabel("Find colors");
        panel.add(defineSearchColorsLabel);
        panel.add(Box.createHorizontalStrut(10));
        JScrollPane searchPane = new JScrollPane(this.searchTable);
        searchPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add(searchPane);
        panel.add(Box.createHorizontalStrut(10));
        JLabel defineAlternatingColorLabel = new JLabel("Alternating colors");
        panel.add(defineAlternatingColorLabel);
        panel.add(Box.createHorizontalStrut(10));
        JScrollPane alternatingColorPane = new JScrollPane(this.alternatingColorTable);
        alternatingColorPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add(alternatingColorPane);
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void updateColors() {
        this.tableModel.getDataVector().clear();
        this.tableModel.getDataVector().addAll(this.getColorizerVector());
        this.tableModel.fireTableDataChanged();
    }

    private Vector<Vector<Serializable>> getColorizerVector() {
        Vector<Vector<Serializable>> data = new Vector<Vector<Serializable>>();
        Map map = this.colorizer.getRules();
        for (Map.Entry o1 : map.entrySet()) {
            Map.Entry entry = o1;
            if (!entry.getKey().equals("Default")) continue;
            for (Object o : (List)entry.getValue()) {
                ColorRule rule = (ColorRule)o;
                Vector<Object> v = new Vector<Object>();
                v.add(rule.getExpression());
                v.add(rule.getBackgroundColor());
                v.add(rule.getForegroundColor());
                data.add(v);
            }
        }
        return data;
    }

    private void configureTable() {
        this.table.setToolTipText("Double click to edit");
        this.table.setRowHeight(20);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        Vector backgroundColors = this.colorizer.getDefaultColors();
        Vector foregroundColors = this.colorizer.getDefaultColors();
        backgroundColors.add("Browse...");
        foregroundColors.add("Browse...");
        JComboBox background = new JComboBox(backgroundColors);
        background.setMaximumRowCount(15);
        background.setRenderer(new ColorListCellRenderer());
        JComboBox foreground = new JComboBox(foregroundColors);
        foreground.setMaximumRowCount(15);
        foreground.setRenderer(new ColorListCellRenderer());
        DefaultCellEditor backgroundEditor = new DefaultCellEditor(background);
        DefaultCellEditor foregroundEditor = new DefaultCellEditor(foreground);
        JTextField textField = new JTextField();
        textField.addKeyListener(new ExpressionRuleContext(this.filterModel, textField));
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(textField));
        this.table.getColumnModel().getColumn(1).setCellEditor(backgroundEditor);
        this.table.getColumnModel().getColumn(2).setCellEditor(foregroundEditor);
        background.addItemListener(new ColorItemListener(background));
        foreground.addItemListener(new ColorItemListener(foreground));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new ExpressionTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ColorTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new ColorTableCellRenderer());
    }

    private void configureSingleEntryColorTable(JTable thisTable) {
        thisTable.setToolTipText("Double click to edit");
        thisTable.setRowHeight(20);
        thisTable.setSelectionMode(0);
        thisTable.setColumnSelectionAllowed(false);
        Vector backgroundColors = this.colorizer.getDefaultColors();
        Vector foregroundColors = this.colorizer.getDefaultColors();
        backgroundColors.add("Browse...");
        foregroundColors.add("Browse...");
        JComboBox background = new JComboBox(backgroundColors);
        background.setMaximumRowCount(15);
        background.setRenderer(new ColorListCellRenderer());
        JComboBox foreground = new JComboBox(foregroundColors);
        foreground.setMaximumRowCount(15);
        foreground.setRenderer(new ColorListCellRenderer());
        DefaultCellEditor backgroundEditor = new DefaultCellEditor(background);
        DefaultCellEditor foregroundEditor = new DefaultCellEditor(foreground);
        thisTable.getColumnModel().getColumn(0).setCellEditor(backgroundEditor);
        thisTable.getColumnModel().getColumn(1).setCellEditor(foregroundEditor);
        background.addItemListener(new ColorItemListener(background));
        foreground.addItemListener(new ColorItemListener(foreground));
        thisTable.getColumnModel().getColumn(0).setCellRenderer(new ColorTableCellRenderer());
        thisTable.getColumnModel().getColumn(1).setCellRenderer(new ColorTableCellRenderer());
    }

    public void setCloseActionListener(ActionListener listener) {
        this.closeListener = listener;
    }

    public void hidePanel() {
        if (this.closeListener != null) {
            this.closeListener.actionPerformed(null);
        }
    }

    void applyRules(String ruleSet, RuleColorizer applyingColorizer) {
        this.table.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
        ArrayList<ColorRule> list = new ArrayList<ColorRule>();
        Vector<Vector> vector = this.tableModel.getDataVector();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            Vector v = vector.elementAt(i);
            try {
                Rule expressionRule = ExpressionRule.getRule((String)((String)v.elementAt(0)));
                Color background = this.getBackground();
                Color foreground = this.getForeground();
                if (v.elementAt(1) instanceof Color) {
                    background = (Color)v.elementAt(1);
                }
                if (v.elementAt(2) instanceof Color) {
                    foreground = (Color)v.elementAt(2);
                }
                ColorRule r = new ColorRule((String)v.elementAt(0), expressionRule, background, foreground);
                list.add(r);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (!result.toString().equals("")) {
                    result.append("<br>");
                }
                result.append(iae.getMessage());
            }
        }
        if (result.toString().equals("")) {
            ((ExpressionTableCellRenderer)this.table.getColumnModel().getColumn(0).getCellRenderer()).setToolTipText("Double click to edit");
            this.statusBar.setText(DEFAULT_STATUS);
            HashMap<String, ArrayList<ColorRule>> map = new HashMap<String, ArrayList<ColorRule>>();
            map.put(ruleSet, list);
            applyingColorizer.setRules(map);
        } else {
            this.statusBar.setText("Errors - see expression tooltip (color filters won't be active until errors are resolved)");
            ((ExpressionTableCellRenderer)this.table.getColumnModel().getColumn(0).getCellRenderer()).setToolTipText("<html>" + result.toString() + "</html>");
        }
    }

    JPanel buildClosePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        JButton saveAsDefaultButton = new JButton(" Save as default ");
        saveAsDefaultButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleColorizer defaultColorizer = (RuleColorizer)ColorPanel.this.allLogPanelColorizers.get("Default");
                ColorPanel.this.applyRules("Default", defaultColorizer);
            }
        });
        panel.add(saveAsDefaultButton);
        JButton applyButton = new JButton(" Apply ");
        applyButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPanel.this.applyRules("Default", ColorPanel.this.colorizer);
                ColorPanel.this.saveSearchColors();
                ColorPanel.this.saveAlternatingColors();
                ColorPanel.this.saveBypassFlag();
            }
        });
        panel.add(Box.createHorizontalStrut(10));
        panel.add(applyButton);
        JButton closeButton = new JButton(" Close ");
        closeButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPanel.this.hidePanel();
            }
        });
        panel.add(Box.createHorizontalStrut(10));
        panel.add(closeButton);
        return panel;
    }

    private void saveSearchColors() {
        Vector thisVector = this.searchTableModel.getDataVector().get(0);
        this.applicationPreferenceModel.setSearchBackgroundColor((Color)thisVector.get(0));
        this.applicationPreferenceModel.setSearchForegroundColor((Color)thisVector.get(1));
    }

    private void saveAlternatingColors() {
        Vector thisVector = this.alternatingColorTableModel.getDataVector().get(0);
        this.applicationPreferenceModel.setAlternatingBackgroundColor((Color)thisVector.get(0));
        Color alternatingColorForegroundColor = (Color)thisVector.get(1);
        this.applicationPreferenceModel.setAlternatingForegroundColor(alternatingColorForegroundColor);
    }

    private void saveBypassFlag() {
        this.applicationPreferenceModel.setBypassSearchColors(this.bypassSearchColorsCheckBox.isSelected());
    }

    JPanel buildUpDownPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridLayout(5, 1));
        JButton upButton = new JButton(ChainsawIcons.ICON_UP);
        upButton.setToolTipText("Move selected rule up");
        JButton downButton = new JButton(ChainsawIcons.ICON_DOWN);
        downButton.setToolTipText("Move selected rule down");
        upButton.setEnabled(false);
        downButton.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int index = this.table.getSelectionModel().getMaxSelectionIndex();
                if (index < 0) {
                    downButton.setEnabled(false);
                    upButton.setEnabled(false);
                } else if (index == 0 && this.tableModel.getRowCount() == 1) {
                    downButton.setEnabled(false);
                    upButton.setEnabled(false);
                } else if (index == 0 && this.tableModel.getRowCount() > 1) {
                    downButton.setEnabled(true);
                    upButton.setEnabled(false);
                } else if (index == this.tableModel.getRowCount() - 1) {
                    downButton.setEnabled(false);
                    upButton.setEnabled(true);
                } else {
                    downButton.setEnabled(true);
                    upButton.setEnabled(true);
                }
            }
        });
        JPanel upPanel = new JPanel();
        upPanel.add(upButton);
        JPanel downPanel = new JPanel();
        downPanel.add(downButton);
        innerPanel.add(new JLabel(""));
        innerPanel.add(upPanel);
        innerPanel.add(new JLabel(""));
        innerPanel.add(downPanel);
        panel.add((Component)innerPanel, "Center");
        upButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (index > 0) {
                    Vector<Vector> v = ColorPanel.this.tableModel.getDataVector();
                    Vector row = v.elementAt(index);
                    ColorPanel.this.tableModel.removeRow(index);
                    ColorPanel.this.tableModel.insertRow(--index, row);
                    ColorPanel.this.table.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        });
        downButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (index > -1 && index < ColorPanel.this.tableModel.getRowCount() - 1) {
                    Vector<Vector> v = ColorPanel.this.tableModel.getDataVector();
                    Vector row = v.elementAt(index);
                    ColorPanel.this.tableModel.removeRow(index);
                    ColorPanel.this.tableModel.insertRow(++index, row);
                    ColorPanel.this.table.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        });
        return panel;
    }

    JPanel buildRulesPanel() {
        JPanel listPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(10));
        JLabel rulesLabel = new JLabel("Rules:");
        panel.add(rulesLabel);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 2));
        buttonPanel.setAlignmentX(0.0f);
        JPanel newPanel = new JPanel();
        JButton newButton = new JButton(" New ");
        newButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentRow = ColorPanel.this.table.getSelectedRow();
                Vector<Object> v = new Vector<Object>();
                v.add("");
                v.add(Color.white);
                v.add(Color.black);
                if (currentRow < 0) {
                    ColorPanel.this.tableModel.addRow(v);
                    currentRow = ColorPanel.this.table.getRowCount() - 1;
                } else {
                    ColorPanel.this.tableModel.insertRow(currentRow, v);
                }
                ColorPanel.this.table.getSelectionModel().setSelectionInterval(currentRow, currentRow);
            }
        });
        newPanel.add(newButton);
        JPanel deletePanel = new JPanel();
        JButton deleteButton = new JButton(" Delete ");
        deleteButton.setEnabled(false);
        deleteButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = ColorPanel.this.table.getSelectionModel().getMaxSelectionIndex();
                if (index > -1 && index < ColorPanel.this.table.getRowCount()) {
                    ColorPanel.this.tableModel.removeRow(index);
                    if (index > 0) {
                        --index;
                    }
                    if (ColorPanel.this.tableModel.getRowCount() > 0) {
                        ColorPanel.this.table.getSelectionModel().setSelectionInterval(index, index);
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int index = this.table.getSelectionModel().getMaxSelectionIndex();
                if (index < 0) {
                    deleteButton.setEnabled(false);
                } else {
                    deleteButton.setEnabled(true);
                }
            }
        });
        deletePanel.add(deleteButton);
        buttonPanel.add(newPanel);
        buttonPanel.add(deletePanel);
        listPanel.add((Component)panel, "North");
        JPanel tablePanel = new JPanel(new BorderLayout());
        this.tableScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tablePanel.add((Component)this.tableScrollPane, "Center");
        tablePanel.add((Component)this.buildUpDownPanel(), "East");
        listPanel.add((Component)tablePanel, "Center");
        listPanel.add((Component)buttonPanel, "South");
        return listPanel;
    }

    class SelectedIcon
    implements Icon {
        private boolean isSelected;
        private int width = 9;
        private int height = 18;
        private int[] xPoints = new int[4];
        private int[] yPoints = new int[4];

        public SelectedIcon(boolean isSelected) {
            this.isSelected = isSelected;
            this.xPoints[0] = 0;
            this.yPoints[0] = -1;
            this.xPoints[1] = 0;
            this.yPoints[1] = this.height;
            this.xPoints[2] = this.width;
            this.yPoints[2] = this.height / 2;
            this.xPoints[3] = this.width;
            this.yPoints[3] = this.height / 2 - 1;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.isSelected) {
                int length = this.xPoints.length;
                int[] newXPoints = new int[length];
                int[] newYPoints = new int[length];
                for (int i = 0; i < length; ++i) {
                    newXPoints[i] = this.xPoints[i] + x;
                    newYPoints[i] = this.yPoints[i] + y;
                }
                g.setColor(Color.black);
                g.fillPolygon(newXPoints, newYPoints, length);
            }
        }
    }

    class ExpressionTableCellRenderer
    implements TableCellRenderer {
        JPanel panel = new JPanel();
        JLabel expressionLabel = new JLabel();
        JLabel iconLabel = new JLabel();
        Icon selectedIcon = new SelectedIcon(true);
        Icon unselectedIcon = new SelectedIcon(false);

        ExpressionTableCellRenderer() {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.panel.setOpaque(true);
            this.panel.add(this.iconLabel);
            this.panel.add(Box.createHorizontalStrut(5));
            this.panel.add(this.expressionLabel);
        }

        void setToolTipText(String text) {
            this.panel.setToolTipText(text);
        }

        @Override
        public Component getTableCellRendererComponent(JTable thisTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this.panel;
            }
            Vector<Vector> v = ColorPanel.this.tableModel.getDataVector();
            Vector r = v.elementAt(row);
            this.expressionLabel.setText(value.toString());
            if (r.elementAt(1) instanceof Color) {
                this.expressionLabel.setBackground((Color)r.elementAt(1));
                this.panel.setBackground((Color)r.elementAt(1));
            }
            if (r.elementAt(2) instanceof Color) {
                this.expressionLabel.setForeground((Color)r.elementAt(2));
                this.panel.setForeground((Color)r.elementAt(2));
            }
            if (isSelected) {
                this.iconLabel.setIcon(this.selectedIcon);
            } else {
                this.iconLabel.setIcon(this.unselectedIcon);
            }
            return this.panel;
        }
    }

    class ColorTableCellRenderer
    implements TableCellRenderer {
        Border border;
        JPanel panel = new JPanel();

        ColorTableCellRenderer() {
            this.panel.setOpaque(true);
        }

        public Color getCurrentColor() {
            return this.panel.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable thisTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Color) {
                this.panel.setBackground((Color)value);
            }
            if (this.border == null) {
                this.border = BorderFactory.createMatteBorder(2, 2, 2, 2, ColorPanel.this.table.getBackground());
            }
            this.panel.setBorder(this.border);
            return this.panel;
        }
    }

    class ColorItemListener
    implements ItemListener {
        JComboBox box;
        JDialog dialog;
        JColorChooser colorChooser;
        Color lastColor;

        ColorItemListener(JComboBox box) {
            this.box = box;
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(box, "Pick a Color", true, this.colorChooser, e -> {
                box.insertItemAt(this.colorChooser.getColor(), 0);
                box.setSelectedIndex(0);
            }, e -> box.setSelectedItem(this.lastColor));
            this.dialog.setDefaultCloseOperation(0);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.box.getSelectedItem() instanceof Color) {
                    this.box.setBackground((Color)this.box.getSelectedItem());
                    ColorPanel.this.repaint();
                } else {
                    this.box.setBackground(Color.white);
                    int selectedRow = ColorPanel.this.table.getSelectedRow();
                    int selectedColumn = ColorPanel.this.table.getSelectedColumn();
                    if (selectedRow != -1 && selectedColumn != -1) {
                        this.colorChooser.setColor((Color)ColorPanel.this.table.getValueAt(selectedRow, selectedColumn));
                        this.lastColor = (Color)ColorPanel.this.table.getValueAt(selectedRow, selectedColumn);
                    }
                    this.dialog.setVisible(true);
                }
            }
        }
    }

    class ColorListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ColorListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(" ");
            if (isSelected && index > -1) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            if (value instanceof Color) {
                this.setBackground((Color)value);
            } else {
                this.setBackground(Color.white);
                if (value != null) {
                    this.setText(value.toString());
                }
            }
            return this;
        }
    }
}

