/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.generator;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.docgen.generator.BaseTypes;
import org.apache.logging.log4j.docgen.generator.DocumentationGeneratorArgs;
import org.apache.logging.log4j.docgen.generator.DocumentationTemplate;
import org.apache.logging.log4j.docgen.generator.internal.ArtifactSourcedType;
import org.apache.logging.log4j.docgen.generator.internal.TypeLookup;
import org.apache.logging.log4j.tools.internal.freemarker.util.FreeMarkerUtils;
import org.jspecify.annotations.Nullable;

public final class DocumentationGenerator {
    private DocumentationGenerator() {
    }

    public static void generateDocumentation(DocumentationGeneratorArgs args) {
        Objects.requireNonNull(args, "args");
        List extendedSets = Stream.concat(BaseTypes.PLUGIN_SETS.stream(), args.pluginSets.stream()).collect(Collectors.toList());
        TypeLookup lookup = TypeLookup.of(extendedSets, args.classNameFilter);
        lookup.values().forEach(sourcedType -> DocumentationGenerator.renderType(sourcedType, lookup, args.templateDirectory, args.typeTemplates));
        DocumentationGenerator.renderIndex(lookup, args.templateDirectory, args.indexTemplates);
    }

    private static void renderType(ArtifactSourcedType sourcedType, TypeLookup lookup, Path templateDirectory, Set<DocumentationTemplate> templates) {
        Map<String, TypeLookup> templateData = Map.of("sourcedType", sourcedType, "lookup", lookup);
        templates.forEach(template -> {
            Path targetPath = DocumentationGenerator.createTypeTargetPath(sourcedType, template.targetPath);
            FreeMarkerUtils.render((Path)templateDirectory, (String)template.name, (Object)templateData, (Path)targetPath);
        });
    }

    private static Path createTypeTargetPath(ArtifactSourcedType sourcedType, String targetPathPattern) {
        String groupId = DocumentationGenerator.or(sourcedType.groupId, "unknown-groupId");
        String artifactId = DocumentationGenerator.or(sourcedType.artifactId, "unknown-artifactId");
        String version = DocumentationGenerator.or(sourcedType.version, "unknown-version");
        String targetPath = targetPathPattern.replaceAll("%g", groupId).replaceAll("%a", artifactId).replaceAll("%v", version).replaceAll("%c", sourcedType.type.getClassName());
        return Path.of(targetPath, new String[0]);
    }

    private static String or(@Nullable String value, String fallback) {
        return value != null ? value : fallback;
    }

    private static void renderIndex(TypeLookup lookup, Path templateDirectory, Set<DocumentationTemplate> templates) {
        Map<String, TypeLookup> templateData = Map.of("lookup", lookup);
        templates.forEach(template -> FreeMarkerUtils.render((Path)templateDirectory, (String)template.name, (Object)templateData, (Path)Path.of(template.targetPath, new String[0])));
    }
}

