/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.exporter;

import java.util.Objects;
import org.apache.logging.log4j.changelog.ChangelogFiles;

public final class ChangelogExporterTemplate {
    final String sourceFileName;
    final String targetFileName;
    final boolean failIfNotFound;

    public ChangelogExporterTemplate(String sourceFileName, String targetFileName, boolean failIfNotFound) {
        this.sourceFileName = ChangelogExporterTemplate.requireTemplateFileName(sourceFileName, "sourceFileName");
        this.targetFileName = Objects.requireNonNull(targetFileName, "targetFileName");
        this.failIfNotFound = failIfNotFound;
    }

    private static String requireTemplateFileName(String fileName, String fieldName) {
        Objects.requireNonNull(fileName, fieldName);
        String templateFileNameSuffix = '.' + ChangelogFiles.templateFileNameExtension();
        if (!fileName.endsWith(templateFileNameSuffix)) {
            String message = String.format("`%s` contains file name without a `%s` suffix: `%s`", fieldName, templateFileNameSuffix, fileName);
            throw new IllegalArgumentException(message);
        }
        return fileName;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        ChangelogExporterTemplate template = (ChangelogExporterTemplate)instance;
        return this.failIfNotFound == template.failIfNotFound && this.sourceFileName.equals(template.sourceFileName) && this.targetFileName.equals(template.targetFileName);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFileName, this.targetFileName, this.failIfNotFound);
    }

    public String toString() {
        return String.format("`%s` \u2192 `%s`%s", this.sourceFileName, this.targetFileName, this.failIfNotFound ? " (failIfNotFound)" : "");
    }
}

