/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractCompressAction;

public final class ZipCompressAction
extends AbstractCompressAction {
    private final String fileName;
    private final int compressionLevel;

    public ZipCompressAction(Path source, Path destination, int compressionLevel) {
        super(source, destination);
        this.fileName = source.getFileName().toString();
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected OutputStream wrapOutputStream(OutputStream stream) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(stream);
        zos.setLevel(this.compressionLevel);
        ZipEntry zipEntry = new ZipEntry(this.fileName);
        zos.putNextEntry(zipEntry);
        return zos;
    }

    @Override
    protected String getAlgorithmName() {
        return "ZIP";
    }
}

