/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.async;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Blocking")
public class BlockingAppender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    public List<LogEvent> logEvents = new CopyOnWriteArrayList<LogEvent>();
    public CountDownLatch countDownLatch = null;

    public BlockingAppender(String name) {
        super(name, null, null, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        event.getMessage().getFormattedMessage();
        List<LogEvent> events = this.logEvents;
        if (events != null) {
            events.add(event.toImmutable());
        }
        if (this.countDownLatch == null) {
            return;
        }
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @PluginFactory
    public static BlockingAppender createAppender(@PluginAttribute @Required(message="No name provided for HangingAppender") String name, @PluginElement Layout layout, @PluginElement Filter filter) {
        return new BlockingAppender(name);
    }

    public void start() {
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.setStopped();
        return true;
    }
}

