/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

class ReadOnlyStringMapResolver
implements EventResolver {
    private final EventResolver internalResolver;

    ReadOnlyStringMapResolver(EventResolverContext context, TemplateResolverConfig config, Function<LogEvent, ReadOnlyStringMap> mapAccessor) {
        this.internalResolver = ReadOnlyStringMapResolver.createResolver(context, config, mapAccessor);
    }

    private static EventResolver createResolver(EventResolverContext context, TemplateResolverConfig config, Function<LogEvent, ReadOnlyStringMap> mapAccessor) {
        boolean flatten;
        Object flattenObject = config.getObject("flatten");
        if (flattenObject == null) {
            flatten = false;
        } else if (flattenObject instanceof Boolean) {
            flatten = (Boolean)flattenObject;
        } else if (flattenObject instanceof Map) {
            flatten = true;
        } else {
            throw new IllegalArgumentException("invalid flatten option: " + config);
        }
        String prefix = config.getString(new String[]{"flatten", "prefix"});
        String key = config.getString("key");
        if (key != null && flatten) {
            throw new IllegalArgumentException("key and flatten options cannot be combined: " + config);
        }
        String pattern = config.getString("pattern");
        if (pattern != null && key != null) {
            throw new IllegalArgumentException("pattern and key options cannot be combined: " + config);
        }
        String replacement = config.getString("replacement");
        if (pattern == null && replacement != null) {
            throw new IllegalArgumentException("replacement cannot be provided without a pattern: " + config);
        }
        boolean stringified = config.getBoolean("stringified", false);
        if (key != null) {
            return ReadOnlyStringMapResolver.createKeyResolver(key, stringified, mapAccessor);
        }
        RecyclerFactory recyclerFactory = context.getConfiguration().getRecyclerFactory();
        return ReadOnlyStringMapResolver.createResolver(recyclerFactory, flatten, prefix, pattern, replacement, stringified, mapAccessor);
    }

    private static EventResolver createKeyResolver(final String key, final boolean stringified, final Function<LogEvent, ReadOnlyStringMap> mapAccessor) {
        return new EventResolver(){

            @Override
            public boolean isResolvable(LogEvent logEvent) {
                ReadOnlyStringMap map = (ReadOnlyStringMap)mapAccessor.apply(logEvent);
                return map != null && map.containsKey(key);
            }

            @Override
            public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
                Object value;
                ReadOnlyStringMap map = (ReadOnlyStringMap)mapAccessor.apply(logEvent);
                Object object = value = map == null ? null : map.getValue(key);
                if (stringified) {
                    String valueString = String.valueOf(value);
                    jsonWriter.writeString(valueString);
                } else {
                    jsonWriter.writeValue(value);
                }
            }
        };
    }

    private static EventResolver createResolver(RecyclerFactory recyclerFactory, boolean flatten, String prefix, String pattern, String replacement, boolean stringified, Function<LogEvent, ReadOnlyStringMap> mapAccessor) {
        Pattern compiledPattern = pattern == null ? null : Pattern.compile(pattern);
        Recycler loopContextRecycler = recyclerFactory.create(() -> {
            LoopContext loopContext = new LoopContext();
            if (prefix != null) {
                loopContext.prefix = prefix;
                loopContext.prefixedKey = new StringBuilder(prefix);
            }
            loopContext.pattern = compiledPattern;
            loopContext.replacement = replacement;
            loopContext.stringified = stringified;
            return loopContext;
        });
        return ReadOnlyStringMapResolver.createResolver(flatten, (Recycler<LoopContext>)loopContextRecycler, mapAccessor);
    }

    private static EventResolver createResolver(final boolean flatten, final Recycler<LoopContext> loopContextRecycler, final Function<LogEvent, ReadOnlyStringMap> mapAccessor) {
        return new EventResolver(){

            @Override
            public boolean isFlattening() {
                return flatten;
            }

            @Override
            public boolean isResolvable(LogEvent logEvent) {
                ReadOnlyStringMap map = (ReadOnlyStringMap)mapAccessor.apply(logEvent);
                return map != null && !map.isEmpty();
            }

            @Override
            public void resolve(LogEvent value, JsonWriter jsonWriter) {
                this.resolve(value, jsonWriter, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolve(LogEvent logEvent, JsonWriter jsonWriter, boolean succeedingEntry) {
                ReadOnlyStringMap map = (ReadOnlyStringMap)mapAccessor.apply(logEvent);
                if (map == null || map.isEmpty()) {
                    if (!flatten) {
                        jsonWriter.writeNull();
                    }
                    return;
                }
                if (!flatten) {
                    jsonWriter.writeObjectStart();
                }
                LoopContext loopContext = (LoopContext)loopContextRecycler.acquire();
                loopContext.jsonWriter = jsonWriter;
                loopContext.initJsonWriterStringBuilderLength = jsonWriter.getStringBuilder().length();
                loopContext.succeedingEntry = flatten && succeedingEntry;
                try {
                    map.forEach((TriConsumer)LoopMethod.INSTANCE, (Object)loopContext);
                }
                finally {
                    loopContextRecycler.release((Object)loopContext);
                }
                if (!flatten) {
                    jsonWriter.writeObjectEnd();
                }
            }
        };
    }

    @Override
    public boolean isFlattening() {
        return this.internalResolver.isFlattening();
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.internalResolver.isResolvable(logEvent);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter, boolean succeedingEntry) {
        this.internalResolver.resolve(logEvent, jsonWriter, succeedingEntry);
    }

    private static final class LoopContext {
        private String prefix;
        private StringBuilder prefixedKey;
        private Pattern pattern;
        private String replacement;
        private boolean stringified;
        private JsonWriter jsonWriter;
        private int initJsonWriterStringBuilderLength;
        private boolean succeedingEntry;

        private LoopContext() {
        }
    }

    private static enum LoopMethod implements TriConsumer<String, Object, LoopContext>
    {
        INSTANCE;


        public void accept(String key, Object value, LoopContext loopContext) {
            boolean keyMatched;
            Matcher matcher = loopContext.pattern != null ? loopContext.pattern.matcher(key) : null;
            boolean bl = keyMatched = matcher == null || matcher.matches();
            if (keyMatched) {
                boolean succeedingEntry;
                String replacedKey = matcher != null && loopContext.replacement != null ? matcher.replaceAll(loopContext.replacement) : key;
                boolean bl2 = succeedingEntry = loopContext.succeedingEntry || loopContext.initJsonWriterStringBuilderLength < loopContext.jsonWriter.getStringBuilder().length();
                if (succeedingEntry) {
                    loopContext.jsonWriter.writeSeparator();
                }
                if (loopContext.prefix == null) {
                    loopContext.jsonWriter.writeObjectKey(replacedKey);
                } else {
                    loopContext.prefixedKey.setLength(loopContext.prefix.length());
                    loopContext.prefixedKey.append(replacedKey);
                    loopContext.jsonWriter.writeObjectKey(loopContext.prefixedKey);
                }
                if (loopContext.stringified && !(value instanceof String)) {
                    String valueString = String.valueOf(value);
                    loopContext.jsonWriter.writeString(valueString);
                } else {
                    loopContext.jsonWriter.writeValue(value);
                }
            }
        }
    }
}

