<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: default
title: Powered By Mahout

    
---

# Powered by Mahout

Are you using Mahout to do Machine Learning? <a href="https://mahout.apache.org/general/mailing-lists,-irc-and-archives.html">Care to share</a>? Developers of the project always are happy to learn about new happy users with interesting use cases.

*Links here do NOT imply
endorsement by Mahout, its committers or the Apache Software Foundation and
are for informational purposes only.*

<a name="PoweredByMahout-CommercialUse"></a>
## Commercial Use

* <a href="http://nosql.mypopescu.com/post/2082712431/hbase-and-hadoop-at-adobe">Adobe AMP</a> uses Mahout's clustering algorithms to increase video
consumption by better user targeting. 
* Accenture uses Mahout as typical example for their [Hadoop Deployment Comparison Study](http://www.accenture.com/SiteCollectionDocuments/PDF/Accenture-Hadoop-Deployment-Comparison-Study.pdf)
* [AOL](http://www.aol.com)
 use Mahout for shopping recommendations. See [slide deck](http://www.slideshare.net/kryton/the-data-layer)
* [Booz Allen Hamilton](http://www.boozallen.com/)
 uses Mahout's clustering algorithms. See [slide deck](http://www.slideshare.net/ydn/3-biometric-hadoopsummit2010)
* [Buzzlogic](http://www.buzzlogic.com)
 uses Mahout's clustering algorithms to improve ad targeting
* [Cull.tv](http://cull.tv/)
 uses modified Mahout algorithms for content recommendations
* ![DatamineLab](http://cdn.dataminelab.com/favicon.ico) [DataMine Lab](http://dataminelab.com)
 uses Mahout's recommendation and clustering algorithms to improve our
clients' ad targeting.
* [Drupal](http://drupal.org/project/recommender)
 uses Mahout to provide open source content recommendation solutions.
* [Evolv ](http://www.evolvondemand.com)
 uses Mahout for its Workforce Predictive Analytics platform.
* [Foursquare](http://www.foursquare.com)
 uses Mahout for its [recommendation engine](http://engineering.foursquare.com/2011/03/22/building-a-recommendation-engine-foursquare-style/).
* [Idealo](http://www.idealo.de)
 uses Mahout's recommendation engine.
* [InfoGlutton](http://www.infoglutton.com)
 uses Mahout's clustering and classification for various consulting
projects.
* [Intel](http://mark.chmarny.com/2013/07/thinking-big-about-data-at-intel.html)
 ships Mahout as part of their Distribution for Apache Hadoop Software.
* [Intela](http://www.intela.com/)
 has implementations of Mahout's recommendation algorithms to select new
offers to send tu customers, as well as to recommend potential customers to
current offers. We are also working on enhancing our offer categories by
using the clustering algorithms.
* ![iOffer](http://ioffer.com/favicon.ico) [iOffer](http://www.ioffer.com)
 uses Mahout's Frequent Pattern Mining and Collaborative Filtering to
recommend items to users.
* ![kau.li](http://kau.li/favicon.ico) [Kauli](http://kau.li/en)
, one of Japanese Adnetwork, uses Mahout's clustering to handle clickstream
data for predicting audience's interests and intents.
* [Linked.In](http://linkedin.com)
 Historically, we have used R for model training. We have recently started
experimenting with Mahout for model training and are excited about it - also see
 <a href="https://www.quora.com/LinkedIn-Recommendations/How-does-LinkedIns-recommendation-system-work?srid=XoeG&share=1">Hadoop World slides</a>
.
* [LucidWorks Big Data](http://www.lucidworks.com/products/lucidworks-big-data)
 uses Mahout for clustering, duplicate document detection, phrase
extraction and classification.
* ![Mendeley](http://mendeley.com/favicon.ico) [Mendeley](http://mendeley.com)
 uses Mahout to power Mendeley Suggest, a research article recommendation
service.
* ![Mippin](http://mippin.com/web/favicon.ico) [Mippin](http://mippin.com)
 uses Mahout's collaborative filtering engine to recommend news feeds
* [Mobage](http://www.slideshare.net/hamadakoichi/mobage-prmu-2011-mahout-hadoop)
 uses Mahout in their analysis pipeline
* ![Myrrix](http://myrrix.com/wp-content/uploads/2012/03/favicon.ico) [Myrrix](http://myrrix.com)
 is a recommender system product built on Mahout.
* ![Newscred](http://www.newscred.com/static/img/website/favicon.ico) [NewsCred](http://platform.newscred.com)
 uses Mahout to generate clusters of news articles and to surface the
important stories of the day
* [Next Glass](http://nextglass.co/)
 uses Mahout
* [Predixion Software](http://predixionsoftware.com/)
 uses Mahout’s algorithms to build predictive models on big data
* <img src="http://www.radoop.eu/wp-content/uploads/favicon.png" width=15> [Radoop](http://radoop.eu)
 provides a drag-n-drop interface for big data analytics, including Mahout
clustering and classification algorithms
* ![Researchgate](https://www.researchgate.net/favicon.ico) [ResearchGate](http://www.researchgate.net/), the professional network for scientists and researchers, uses Mahout's
recommendation algorithms.
* [Sematext](http://www.sematext.com/)
 uses Mahout for its recommendation engine
* [SpeedDate.com](http://www.speeddate.com)
 uses Mahout's collaborative filtering engine to recommend member profiles
* [Twitter](http://twitter.com)
 uses Mahout's LDA implementation for user interest modeling
* [Yahoo\!](http://www.yahoo.com)
 Mail uses Mahout's Frequent Pattern Set Mining.  See [slides](http://www.slideshare.net/hadoopusergroup/mail-antispam)
* [365Media ](http://365media.com/)
 uses *Mahout's* Classification and Collaborative Filtering algorithms in
its Real-time system named [UPTIME](http://uptime.365media.com/)
 and 365Media/Social

<a name="PoweredByMahout-AcademicUse"></a>
## Academic Use

* [Dicode](https://www.dicode-project.eu/)
 project uses Mahout's clustering and classification algorithms on top of
HBase.
* The course [Large Scale Data Analysis and Data Mining](http://www.dima.tu-berlin.de/menue/teaching/masterstudium/aim-3/)
 at TU Berlin uses Mahout to teach students about the parallelization of data
mining problems with Hadoop and Map/Reduce
* Mahout is used at Carnegie Mellon University, as a comparable platform to [GraphLab](http://www.graphlab.ml.cmu.edu/)

* The [ROBUST project](http://www.robust-project.eu/)
, co-funded by the European Commission, employs Mahout in the large scale
analysis of online community data.
* Mahout is used for research and data processing at [Nagoya Institute of Technology](http://www.nitech.ac.jp/eng/schools/grad/cse.html)
, in the context of a large-scale citizen participation platform project,
funded by the Ministry of Interior of Japan.
* Several researches within [Digital Enterprise Research Institute](http://www.deri.ie)
 [NUI Galway](http://www.nuigalway.ie)
 use Mahout for e.g. topic mining and modelling of large corpora.
* Mahout is used in the NoTube EU project.

<a name="PoweredByMahout-PoweredByLogos"></a>
## Powered By Logos

Feel free to use our **Powered By** logos on your site:

![powered by logo](https://mahout.apache.org/images/mahout-logo-poweredby-55.png)


![powered by logo](https://mahout.apache.org/images/mahout-logo-poweredby-100.png)