/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiTermVectorsShardRequest
extends SingleShardOperationRequest<MultiTermVectorsShardRequest> {
    private int shardId;
    private String preference;
    IntArrayList locations;
    List<TermVectorRequest> requests;

    MultiTermVectorsShardRequest() {
    }

    MultiTermVectorsShardRequest(String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new IntArrayList();
        this.requests = new ArrayList<TermVectorRequest>();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiTermVectorsShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public void add(int location, TermVectorRequest request) {
        this.locations.add(location);
        this.requests.add(request);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.requests = new ArrayList<TermVectorRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            this.requests.add(TermVectorRequest.readTermVectorRequest(in));
        }
        this.preference = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            this.requests.get(i).writeTo(out);
        }
        out.writeOptionalString(this.preference);
    }
}

