/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportClientNodesService
extends AbstractComponent {
    private final TimeValue nodesSamplerInterval;
    private final long pingTimeout;
    private final ClusterName clusterName;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Version version;
    private volatile ImmutableList<DiscoveryNode> listedNodes = ImmutableList.of();
    private final Object mutex = new Object();
    private volatile ImmutableList<DiscoveryNode> nodes = ImmutableList.of();
    private volatile ImmutableList<DiscoveryNode> filteredNodes = ImmutableList.of();
    private final AtomicInteger tempNodeIdGenerator = new AtomicInteger();
    private final NodeSampler nodesSampler;
    private volatile ScheduledFuture nodesSamplerFuture;
    private final AtomicInteger randomNodeGenerator = new AtomicInteger();
    private final boolean ignoreClusterName;
    private volatile boolean closed;

    @Inject
    public TransportClientNodesService(Settings settings, ClusterName clusterName, TransportService transportService, ThreadPool threadPool, Version version) {
        super(settings);
        this.clusterName = clusterName;
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.version = version;
        this.nodesSamplerInterval = this.componentSettings.getAsTime("nodes_sampler_interval", TimeValue.timeValueSeconds(5L));
        this.pingTimeout = this.componentSettings.getAsTime("ping_timeout", TimeValue.timeValueSeconds(5L)).millis();
        this.ignoreClusterName = this.componentSettings.getAsBoolean("ignore_cluster_name", (Boolean)false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("node_sampler_interval[" + this.nodesSamplerInterval + "]", new Object[0]);
        }
        this.nodesSampler = this.componentSettings.getAsBoolean("sniff", (Boolean)false) != false ? new SniffNodesSampler() : new SimpleNodeSampler();
        this.nodesSamplerFuture = threadPool.schedule(this.nodesSamplerInterval, "generic", new ScheduledNodeSampler());
        transportService.throwConnectException(true);
    }

    public ImmutableList<TransportAddress> transportAddresses() {
        ImmutableList.Builder lstBuilder = ImmutableList.builder();
        for (DiscoveryNode listedNode : this.listedNodes) {
            lstBuilder.add(listedNode.address());
        }
        return lstBuilder.build();
    }

    public ImmutableList<DiscoveryNode> connectedNodes() {
        return this.nodes;
    }

    public ImmutableList<DiscoveryNode> filteredNodes() {
        return this.filteredNodes;
    }

    public ImmutableList<DiscoveryNode> listedNodes() {
        return this.listedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService addTransportAddresses(TransportAddress ... transportAddresses) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new ElasticsearchIllegalStateException("transport client is closed, can't add an address");
            }
            ArrayList<TransportAddress> filtered = Lists.newArrayListWithExpectedSize(transportAddresses.length);
            for (TransportAddress transportAddress : transportAddresses) {
                boolean found = false;
                for (DiscoveryNode otherNode : this.listedNodes) {
                    if (!otherNode.address().equals(transportAddress)) continue;
                    found = true;
                    this.logger.debug("address [{}] already exists with [{}], ignoring...", transportAddress, otherNode);
                    break;
                }
                if (found) continue;
                filtered.add(transportAddress);
            }
            if (filtered.isEmpty()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.listedNodes());
            for (TransportAddress transportAddress : filtered) {
                DiscoveryNode node = new DiscoveryNode("#transport#-" + this.tempNodeIdGenerator.incrementAndGet(), transportAddress, this.version);
                this.logger.debug("adding address [{}]", node);
                builder.add(node);
            }
            this.listedNodes = builder.build();
            this.nodesSampler.sample();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService removeTransportAddress(TransportAddress transportAddress) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new ElasticsearchIllegalStateException("transport client is closed, can't remove an address");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DiscoveryNode otherNode : this.listedNodes) {
                if (!otherNode.address().equals(transportAddress)) {
                    builder.add(otherNode);
                    continue;
                }
                this.logger.debug("removing address [{}]", otherNode);
            }
            this.listedNodes = builder.build();
            this.nodesSampler.sample();
        }
        return this;
    }

    public <T> T execute(NodeCallback<T> callback) throws ElasticsearchException {
        ImmutableList<DiscoveryNode> nodes = this.nodes;
        if (nodes.isEmpty()) {
            throw new NoNodeAvailableException();
        }
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            DiscoveryNode node = (DiscoveryNode)nodes.get((index + i) % nodes.size());
            try {
                return callback.doWithNode(node);
            }
            catch (ElasticsearchException e) {
                if (e.unwrapCause() instanceof ConnectTransportException) continue;
                throw e;
            }
        }
        throw new NoNodeAvailableException();
    }

    public <Response> void execute(NodeListenerCallback<Response> callback, ActionListener<Response> listener) throws ElasticsearchException {
        ImmutableList<DiscoveryNode> nodes = this.nodes;
        if (nodes.isEmpty()) {
            throw new NoNodeAvailableException();
        }
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        RetryListener<Response> retryListener = new RetryListener<Response>(callback, listener, nodes, index);
        try {
            callback.doWithNode((DiscoveryNode)nodes.get(index % nodes.size()), retryListener);
        }
        catch (ElasticsearchException e) {
            if (e.unwrapCause() instanceof ConnectTransportException) {
                retryListener.onFailure(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.nodesSamplerFuture.cancel(true);
            for (DiscoveryNode node : this.nodes) {
                this.transportService.disconnectFromNode(node);
            }
            for (DiscoveryNode listedNode : this.listedNodes) {
                this.transportService.disconnectFromNode(listedNode);
            }
            this.nodes = ImmutableList.of();
        }
    }

    public static interface NodeListenerCallback<Response> {
        public void doWithNode(DiscoveryNode var1, ActionListener<Response> var2) throws ElasticsearchException;
    }

    public static interface NodeCallback<T> {
        public T doWithNode(DiscoveryNode var1) throws ElasticsearchException;
    }

    class SniffNodesSampler
    extends NodeSampler {
        SniffNodesSampler() {
        }

        @Override
        protected void doSample() {
            HashSet<DiscoveryNode> nodesToPing = Sets.newHashSet();
            for (DiscoveryNode node : TransportClientNodesService.this.listedNodes) {
                nodesToPing.add(node);
            }
            for (DiscoveryNode node : TransportClientNodesService.this.nodes) {
                nodesToPing.add(node);
            }
            final CountDownLatch latch = new CountDownLatch(nodesToPing.size());
            final ConcurrentMap clusterStateResponses = ConcurrentCollections.newConcurrentMap();
            for (final DiscoveryNode listedNode : nodesToPing) {
                TransportClientNodesService.this.threadPool.executor("management").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!TransportClientNodesService.this.transportService.nodeConnected(listedNode)) {
                                try {
                                    if (TransportClientNodesService.this.nodes.contains(listedNode)) {
                                        TransportClientNodesService.this.logger.trace("connecting to cluster node [{}]", listedNode);
                                        TransportClientNodesService.this.transportService.connectToNode(listedNode);
                                    } else {
                                        TransportClientNodesService.this.logger.trace("connecting to listed node (light) [{}]", listedNode);
                                        TransportClientNodesService.this.transportService.connectToNodeLight(listedNode);
                                    }
                                }
                                catch (Exception e) {
                                    TransportClientNodesService.this.logger.debug("failed to connect to node [{}], ignoring...", e, listedNode);
                                    latch.countDown();
                                    return;
                                }
                            }
                            TransportClientNodesService.this.transportService.sendRequest(listedNode, "cluster/state", (TransportRequest)Requests.clusterStateRequest().clear().nodes(true).local(true), TransportRequestOptions.options().withType(TransportRequestOptions.Type.STATE).withTimeout(TransportClientNodesService.this.pingTimeout), new BaseTransportResponseHandler<ClusterStateResponse>(){

                                @Override
                                public ClusterStateResponse newInstance() {
                                    return new ClusterStateResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(ClusterStateResponse response) {
                                    clusterStateResponses.put(listedNode, response);
                                    latch.countDown();
                                }

                                @Override
                                public void handleException(TransportException e) {
                                    TransportClientNodesService.this.logger.info("failed to get local cluster state for {}, disconnecting...", e, listedNode);
                                    TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                                    latch.countDown();
                                }
                            });
                        }
                        catch (Throwable e) {
                            TransportClientNodesService.this.logger.info("failed to get local cluster state info for {}, disconnecting...", e, listedNode);
                            TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>(TransportClientNodesService.this.listedNodes);
            HashSet newFilteredNodes = new HashSet();
            for (Map.Entry entry : clusterStateResponses.entrySet()) {
                if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(((ClusterStateResponse)entry.getValue()).getClusterName())) {
                    TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", ((ClusterStateResponse)entry.getValue()).getState().nodes().localNode(), TransportClientNodesService.this.clusterName);
                    newFilteredNodes.add(entry.getKey());
                    continue;
                }
                for (ObjectCursor<DiscoveryNode> objectCursor : ((ClusterStateResponse)entry.getValue()).getState().nodes().dataNodes().values()) {
                    newNodes.add((DiscoveryNode)objectCursor.value);
                }
            }
            TransportClientNodesService.this.nodes = this.validateNewNodes(newNodes);
            TransportClientNodesService.this.filteredNodes = ImmutableList.copyOf(newFilteredNodes);
        }
    }

    class SimpleNodeSampler
    extends NodeSampler {
        SimpleNodeSampler() {
        }

        @Override
        protected void doSample() {
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            HashSet<DiscoveryNode> newFilteredNodes = new HashSet<DiscoveryNode>();
            for (DiscoveryNode listedNode : TransportClientNodesService.this.listedNodes) {
                if (!TransportClientNodesService.this.transportService.nodeConnected(listedNode)) {
                    try {
                        TransportClientNodesService.this.logger.trace("connecting to listed node (light) [{}]", listedNode);
                        TransportClientNodesService.this.transportService.connectToNodeLight(listedNode);
                    }
                    catch (Throwable e) {
                        TransportClientNodesService.this.logger.debug("failed to connect to node [{}], removed from nodes list", e, listedNode);
                        continue;
                    }
                }
                try {
                    NodesInfoResponse nodeInfo = TransportClientNodesService.this.transportService.submitRequest(listedNode, "cluster/nodes/info", Requests.nodesInfoRequest("_local"), TransportRequestOptions.options().withType(TransportRequestOptions.Type.STATE).withTimeout(TransportClientNodesService.this.pingTimeout), new FutureTransportResponseHandler<NodesInfoResponse>(){

                        @Override
                        public NodesInfoResponse newInstance() {
                            return new NodesInfoResponse();
                        }
                    }).txGet();
                    if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(nodeInfo.getClusterName())) {
                        TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", listedNode, TransportClientNodesService.this.clusterName);
                        newFilteredNodes.add(listedNode);
                        continue;
                    }
                    if (((NodeInfo[])nodeInfo.getNodes()).length != 0) {
                        DiscoveryNode nodeWithInfo = ((NodeInfo[])nodeInfo.getNodes())[0].getNode();
                        newNodes.add(new DiscoveryNode(nodeWithInfo.name(), nodeWithInfo.id(), nodeWithInfo.getHostName(), nodeWithInfo.getHostAddress(), listedNode.address(), nodeWithInfo.attributes(), nodeWithInfo.version()));
                        continue;
                    }
                    TransportClientNodesService.this.logger.debug("node {} didn't return any discovery info, temporarily using transport discovery node", listedNode);
                    newNodes.add(listedNode);
                }
                catch (Throwable e) {
                    TransportClientNodesService.this.logger.info("failed to get node info for {}, disconnecting...", e, listedNode);
                    TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                }
            }
            TransportClientNodesService.this.nodes = this.validateNewNodes(newNodes);
            TransportClientNodesService.this.filteredNodes = ImmutableList.copyOf(newFilteredNodes);
        }
    }

    class ScheduledNodeSampler
    implements Runnable {
        ScheduledNodeSampler() {
        }

        @Override
        public void run() {
            try {
                TransportClientNodesService.this.nodesSampler.sample();
                if (!TransportClientNodesService.this.closed) {
                    TransportClientNodesService.this.nodesSamplerFuture = TransportClientNodesService.this.threadPool.schedule(TransportClientNodesService.this.nodesSamplerInterval, "generic", this);
                }
            }
            catch (Exception e) {
                TransportClientNodesService.this.logger.warn("failed to sample", e, new Object[0]);
            }
        }
    }

    abstract class NodeSampler {
        NodeSampler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sample() {
            Object object = TransportClientNodesService.this.mutex;
            synchronized (object) {
                if (TransportClientNodesService.this.closed) {
                    return;
                }
                this.doSample();
            }
        }

        protected abstract void doSample();

        protected ImmutableList<DiscoveryNode> validateNewNodes(Set<DiscoveryNode> nodes) {
            Iterator<DiscoveryNode> it = nodes.iterator();
            while (it.hasNext()) {
                DiscoveryNode node = it.next();
                if (TransportClientNodesService.this.transportService.nodeConnected(node)) continue;
                try {
                    TransportClientNodesService.this.logger.trace("connecting to node [{}]", node);
                    TransportClientNodesService.this.transportService.connectToNode(node);
                }
                catch (Throwable e) {
                    it.remove();
                    TransportClientNodesService.this.logger.debug("failed to connect to discovered node [" + node + "]", e, new Object[0]);
                }
            }
            return ((ImmutableList.Builder)new ImmutableList.Builder().addAll(nodes)).build();
        }
    }

    public static class RetryListener<Response>
    implements ActionListener<Response> {
        private final NodeListenerCallback<Response> callback;
        private final ActionListener<Response> listener;
        private final ImmutableList<DiscoveryNode> nodes;
        private final int index;
        private volatile int i;

        public RetryListener(NodeListenerCallback<Response> callback, ActionListener<Response> listener, ImmutableList<DiscoveryNode> nodes, int index) {
            this.callback = callback;
            this.listener = listener;
            this.nodes = nodes;
            this.index = index;
        }

        @Override
        public void onResponse(Response response) {
            this.listener.onResponse(response);
        }

        @Override
        public void onFailure(Throwable e) {
            if (ExceptionsHelper.unwrapCause(e) instanceof ConnectTransportException) {
                int i;
                if ((i = ++this.i) >= this.nodes.size()) {
                    this.listener.onFailure(new NoNodeAvailableException());
                } else {
                    try {
                        this.callback.doWithNode((DiscoveryNode)this.nodes.get((this.index + i) % this.nodes.size()), this);
                    }
                    catch (Throwable e1) {
                        this.onFailure(e);
                    }
                }
            } else {
                this.listener.onFailure(e);
            }
        }
    }
}

