/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.script.ExplainableSearchScript;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunction
extends ScoreFunction {
    private final String sScript;
    private final Map<String, Object> params;
    private final SearchScript script;

    public ScriptScoreFunction(String sScript, Map<String, Object> params, SearchScript script) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.params = params;
        this.script = script;
    }

    @Override
    public void setNextReader(AtomicReaderContext ctx) {
        this.script.setNextReader(ctx);
    }

    @Override
    public double score(int docId, float subQueryScore) {
        this.script.setNextDocId(docId);
        this.script.setNextScore(subQueryScore);
        return this.script.runAsDouble();
    }

    @Override
    public Explanation explainScore(int docId, Explanation subQueryExpl) {
        Explanation exp;
        if (this.script instanceof ExplainableSearchScript) {
            this.script.setNextDocId(docId);
            this.script.setNextScore(subQueryExpl.getValue());
            exp = ((ExplainableSearchScript)this.script).explain(subQueryExpl);
        } else {
            double score = this.score(docId, subQueryExpl.getValue());
            exp = new Explanation(CombineFunction.toFloat(score), "script score function: composed of:");
            exp.addDetail(subQueryExpl);
        }
        return exp;
    }

    public String toString() {
        return "script[" + this.sScript + "], params [" + this.params + "]";
    }
}

