/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;

public abstract class TimeZoneRounding
implements Rounding {
    @Override
    public abstract long round(long var1);

    public static Builder builder(DateTimeUnit unit) {
        return new Builder(unit);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    static class PrePostTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 8;
        private TimeZoneRounding timeZoneRounding;
        private long preOffset;
        private long postOffset;

        PrePostTimeZoneRounding() {
        }

        PrePostTimeZoneRounding(TimeZoneRounding timeZoneRounding, long preOffset, long postOffset) {
            this.timeZoneRounding = timeZoneRounding;
            this.preOffset = preOffset;
            this.postOffset = postOffset;
        }

        @Override
        public byte id() {
            return 8;
        }

        @Override
        public long round(long utcMillis) {
            return this.postOffset + this.timeZoneRounding.round(utcMillis + this.preOffset);
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.postOffset + this.timeZoneRounding.nextRoundingValue(value - this.postOffset);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.timeZoneRounding = (TimeZoneRounding)Rounding.Streams.read(in);
            this.preOffset = in.readVLong();
            this.postOffset = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Rounding.Streams.write(this.timeZoneRounding, out);
            out.writeVLong(this.preOffset);
            out.writeVLong(this.postOffset);
        }
    }

    static class FactorTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 7;
        private TimeZoneRounding timeZoneRounding;
        private float factor;

        FactorTimeZoneRounding() {
        }

        FactorTimeZoneRounding(TimeZoneRounding timeZoneRounding, float factor) {
            this.timeZoneRounding = timeZoneRounding;
            this.factor = factor;
        }

        @Override
        public byte id() {
            return 7;
        }

        @Override
        public long round(long utcMillis) {
            return this.timeZoneRounding.round((long)(this.factor * (float)utcMillis));
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.timeZoneRounding.nextRoundingValue(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.timeZoneRounding = (TimeZoneRounding)Rounding.Streams.read(in);
            this.factor = in.readFloat();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Rounding.Streams.write(this.timeZoneRounding, out);
            out.writeFloat(this.factor);
        }
    }

    static class DayIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 6;
        private long interval;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        DayIntervalTimeZoneRounding() {
        }

        DayIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 6;
        }

        @Override
        public long round(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = Rounding.Interval.round(time, this.interval);
            time += (long)this.postTz.getOffset(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class TimeIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 5;
        private long interval;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        TimeIntervalTimeZoneRounding() {
        }

        TimeIntervalTimeZoneRounding(long interval, DateTimeZone preTz, DateTimeZone postTz) {
            this.interval = interval;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 5;
        }

        @Override
        public long round(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = Rounding.Interval.round(time, this.interval);
            time -= (long)this.preTz.getOffset(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class UTCIntervalTimeZoneRounding
    extends TimeZoneRounding {
        static final byte ID = 4;
        private long interval;

        UTCIntervalTimeZoneRounding() {
        }

        UTCIntervalTimeZoneRounding(long interval) {
            this.interval = interval;
        }

        @Override
        public byte id() {
            return 4;
        }

        @Override
        public long round(long utcMillis) {
            return Rounding.Interval.round(utcMillis, this.interval);
        }

        @Override
        public long nextRoundingValue(long value) {
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
        }
    }

    static class DayTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 3;
        private DateTimeUnit unit;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        DayTimeZoneRoundingFloor() {
        }

        DayTimeZoneRoundingFloor(DateTimeUnit unit, DateTimeZone preTz, DateTimeZone postTz) {
            this.unit = unit;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 3;
        }

        @Override
        public long round(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = this.unit.field().roundFloor(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.unit.field().getDurationField().getUnitMillis() + value;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    static class UTCTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 2;
        private DateTimeUnit unit;

        UTCTimeZoneRoundingFloor() {
        }

        UTCTimeZoneRoundingFloor(DateTimeUnit unit) {
            this.unit = unit;
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public long round(long utcMillis) {
            return this.unit.field().roundFloor(utcMillis);
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.unit.field().roundCeiling(value + 1L);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
        }
    }

    static class TimeTimeZoneRoundingFloor
    extends TimeZoneRounding {
        static final byte ID = 1;
        private DateTimeUnit unit;
        private DateTimeZone preTz;
        private DateTimeZone postTz;

        TimeTimeZoneRoundingFloor() {
        }

        TimeTimeZoneRoundingFloor(DateTimeUnit unit, DateTimeZone preTz, DateTimeZone postTz) {
            this.unit = unit;
            this.preTz = preTz;
            this.postTz = postTz;
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public long round(long utcMillis) {
            long time = utcMillis + (long)this.preTz.getOffset(utcMillis);
            time = this.unit.field().roundFloor(time);
            time -= (long)this.preTz.getOffset(time);
            time += (long)this.postTz.getOffset(time);
            return time;
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.unit.field().roundCeiling(value + 1L);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.unit = DateTimeUnit.resolve(in.readByte());
            this.preTz = DateTimeZone.forID(in.readSharedString());
            this.postTz = DateTimeZone.forID(in.readSharedString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.id());
            out.writeSharedString(this.preTz.getID());
            out.writeSharedString(this.postTz.getID());
        }
    }

    public static class Builder {
        private DateTimeUnit unit;
        private long interval = -1L;
        private DateTimeZone preTz = DateTimeZone.UTC;
        private DateTimeZone postTz = DateTimeZone.UTC;
        private float factor = 1.0f;
        private long preOffset;
        private long postOffset;
        private boolean preZoneAdjustLargeInterval = false;

        public Builder(DateTimeUnit unit) {
            this.unit = unit;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.unit = null;
            this.interval = interval.millis();
        }

        public Builder preZone(DateTimeZone preTz) {
            this.preTz = preTz;
            return this;
        }

        public Builder preZoneAdjustLargeInterval(boolean preZoneAdjustLargeInterval) {
            this.preZoneAdjustLargeInterval = preZoneAdjustLargeInterval;
            return this;
        }

        public Builder postZone(DateTimeZone postTz) {
            this.postTz = postTz;
            return this;
        }

        public Builder preOffset(long preOffset) {
            this.preOffset = preOffset;
            return this;
        }

        public Builder postOffset(long postOffset) {
            this.postOffset = postOffset;
            return this;
        }

        public Builder factor(float factor) {
            this.factor = factor;
            return this;
        }

        public TimeZoneRounding build() {
            TimeZoneRounding timeZoneRounding = this.unit != null ? (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCTimeZoneRoundingFloor(this.unit) : (this.preZoneAdjustLargeInterval || this.unit.field().getDurationField().getUnitMillis() < 43200000L ? new TimeTimeZoneRoundingFloor(this.unit, this.preTz, this.postTz) : new DayTimeZoneRoundingFloor(this.unit, this.preTz, this.postTz))) : (this.preTz.equals(DateTimeZone.UTC) && this.postTz.equals(DateTimeZone.UTC) ? new UTCIntervalTimeZoneRounding(this.interval) : (this.preZoneAdjustLargeInterval || this.interval < 43200000L ? new TimeIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz) : new DayIntervalTimeZoneRounding(this.interval, this.preTz, this.postTz)));
            if (this.preOffset != 0L || this.postOffset != 0L) {
                timeZoneRounding = new PrePostTimeZoneRounding(timeZoneRounding, this.preOffset, this.postOffset);
            }
            if (this.factor != 1.0f) {
                timeZoneRounding = new FactorTimeZoneRounding(timeZoneRounding, this.factor);
            }
            return timeZoneRounding;
        }
    }
}

