/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.BigByteArray;
import org.elasticsearch.common.util.BigDoubleArray;
import org.elasticsearch.common.util.BigIntArray;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.BigObjectArray;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;

public final class BigArrays
extends Enum<BigArrays> {
    public static final int PAGE_SIZE_IN_BYTES = 16384;
    public static final int BYTE_PAGE_SIZE = 16384;
    public static final int INT_PAGE_SIZE = 4096;
    public static final int LONG_PAGE_SIZE = 2048;
    public static final int DOUBLE_PAGE_SIZE = 2048;
    public static final int OBJECT_PAGE_SIZE;
    private static final /* synthetic */ BigArrays[] $VALUES;

    public static BigArrays[] values() {
        return (BigArrays[])$VALUES.clone();
    }

    public static BigArrays valueOf(String name) {
        return Enum.valueOf(BigArrays.class, name);
    }

    public static long overSize(long minTargetSize) {
        return BigArrays.overSize(minTargetSize, 2048, 1);
    }

    public static long overSize(long minTargetSize, int pageSize, int bytesPerElement) {
        Preconditions.checkArgument(minTargetSize >= 0L, "minTargetSize must be >= 0");
        Preconditions.checkArgument(pageSize >= 0, "pageSize must be > 0");
        Preconditions.checkArgument(bytesPerElement > 0, "bytesPerElement must be > 0");
        long newSize = minTargetSize < (long)pageSize ? (long)ArrayUtil.oversize((int)((int)minTargetSize), (int)bytesPerElement) : minTargetSize + (minTargetSize >>> 3);
        if (newSize > (long)pageSize) {
            newSize = newSize - newSize % (long)pageSize + (long)pageSize;
            assert (newSize % (long)pageSize == 0L);
        }
        return newSize;
    }

    static boolean indexIsInt(long index) {
        return index == (long)((int)index);
    }

    public static ByteArray newByteArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        if (size <= 16384L) {
            return new ByteArrayWrapper(new byte[(int)size], recycler, clearOnResize);
        }
        return new BigByteArray(size, recycler, clearOnResize);
    }

    public static ByteArray newByteArray(long size) {
        return BigArrays.newByteArray(size, null, true);
    }

    public static ByteArray resize(ByteArray array, long size) {
        if (array instanceof BigByteArray) {
            ((BigByteArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        ByteArray newArray = BigArrays.newByteArray(size, arr.recycler, arr.clearOnResize);
        byte[] rawArray = ((ByteArrayWrapper)array).array;
        newArray.set(0L, rawArray, 0, (int)Math.min((long)rawArray.length, newArray.size()));
        return newArray;
    }

    public static ByteArray grow(ByteArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 16384, 1);
        return BigArrays.resize(array, newSize);
    }

    public static IntArray newIntArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        if (size <= 4096L) {
            return new IntArrayWrapper(new int[(int)size], recycler, clearOnResize);
        }
        return new BigIntArray(size, recycler, clearOnResize);
    }

    public static IntArray newIntArray(long size) {
        return BigArrays.newIntArray(size, null, true);
    }

    public static IntArray resize(IntArray array, long size) {
        if (array instanceof BigIntArray) {
            ((BigIntArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        IntArray newArray = BigArrays.newIntArray(size, arr.recycler, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static IntArray grow(IntArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return BigArrays.resize(array, newSize);
    }

    public static LongArray newLongArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        if (size <= 2048L) {
            return new LongArrayWrapper(new long[(int)size], recycler, clearOnResize);
        }
        return new BigLongArray(size, recycler, clearOnResize);
    }

    public static LongArray newLongArray(long size) {
        return BigArrays.newLongArray(size, null, true);
    }

    public static LongArray resize(LongArray array, long size) {
        if (array instanceof BigLongArray) {
            ((BigLongArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        LongArray newArray = BigArrays.newLongArray(size, arr.recycler, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static LongArray grow(LongArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return BigArrays.resize(array, newSize);
    }

    public static DoubleArray newDoubleArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        if (size <= 2048L) {
            return new DoubleArrayWrapper(new double[(int)size], recycler, clearOnResize);
        }
        return new BigDoubleArray(size, recycler, clearOnResize);
    }

    public static DoubleArray newDoubleArray(long size) {
        return BigArrays.newDoubleArray(size, null, true);
    }

    public static DoubleArray resize(DoubleArray array, long size) {
        if (array instanceof BigDoubleArray) {
            ((BigDoubleArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        DoubleArray newArray = BigArrays.newDoubleArray(size, arr.recycler, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static DoubleArray grow(DoubleArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return BigArrays.resize(array, newSize);
    }

    public static <T> ObjectArray<T> newObjectArray(long size, PageCacheRecycler recycler) {
        if (size <= (long)OBJECT_PAGE_SIZE) {
            return new ObjectArrayWrapper(new Object[(int)size], recycler);
        }
        return new BigObjectArray(size, recycler);
    }

    public static <T> ObjectArray<T> newObjectArray(long size) {
        return BigArrays.newObjectArray(size, null);
    }

    public static <T> ObjectArray<T> resize(ObjectArray<T> array, long size) {
        if (array instanceof BigObjectArray) {
            ((BigObjectArray)array).resize(size);
            return array;
        }
        ObjectArray<T> newArray = BigArrays.newObjectArray(size, ((AbstractArray)((Object)array)).recycler);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public static <T> ObjectArray<T> grow(ObjectArray<T> array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, OBJECT_PAGE_SIZE, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        return BigArrays.resize(array, newSize);
    }

    static {
        $VALUES = new BigArrays[0];
        OBJECT_PAGE_SIZE = 16384 / RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    private static class ObjectArrayWrapper<T>
    extends AbstractArray
    implements ObjectArray<T> {
        private final Object[] array;

        ObjectArrayWrapper(Object[] array, PageCacheRecycler recycler) {
            super(recycler, true);
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public T get(long index) {
            assert (BigArrays.indexIsInt(index));
            return (T)this.array[(int)index];
        }

        @Override
        public T set(long index, T value) {
            assert (BigArrays.indexIsInt(index));
            Object ret = this.array[(int)index];
            this.array[(int)index] = value;
            return (T)ret;
        }
    }

    private static class DoubleArrayWrapper
    extends AbstractArray
    implements DoubleArray {
        private final double[] array;

        DoubleArrayWrapper(double[] array, PageCacheRecycler recycler, boolean clearOnResize) {
            super(recycler, clearOnResize);
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public double get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public double set(long index, double value) {
            assert (BigArrays.indexIsInt(index));
            double ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public double increment(long index, double inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            double d = this.array[n] + inc;
            this.array[n] = d;
            return d;
        }

        @Override
        public void fill(long fromIndex, long toIndex, double value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class LongArrayWrapper
    extends AbstractArray
    implements LongArray {
        private final long[] array;

        LongArrayWrapper(long[] array, PageCacheRecycler recycler, boolean clearOnResize) {
            super(recycler, clearOnResize);
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public long get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public long set(long index, long value) {
            assert (BigArrays.indexIsInt(index));
            long ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public long increment(long index, long inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            long l = this.array[n] + inc;
            this.array[n] = l;
            return l;
        }

        @Override
        public void fill(long fromIndex, long toIndex, long value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class IntArrayWrapper
    extends AbstractArray
    implements IntArray {
        private final int[] array;

        IntArrayWrapper(int[] array, PageCacheRecycler recycler, boolean clearOnResize) {
            super(recycler, clearOnResize);
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public int get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public int set(long index, int value) {
            assert (BigArrays.indexIsInt(index));
            int ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public int increment(long index, int inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            int n2 = this.array[n] + inc;
            this.array[n] = n2;
            return n2;
        }
    }

    private static class ByteArrayWrapper
    extends AbstractArray
    implements ByteArray {
        private final byte[] array;

        ByteArrayWrapper(byte[] array, PageCacheRecycler recycler, boolean clearOnResize) {
            super(recycler, clearOnResize);
            this.array = array;
        }

        @Override
        public long size() {
            return this.array.length;
        }

        @Override
        public byte get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public byte set(long index, byte value) {
            assert (BigArrays.indexIsInt(index));
            byte ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public void get(long index, int len, BytesRef ref) {
            assert (BigArrays.indexIsInt(index));
            ref.bytes = this.array;
            ref.offset = (int)index;
            ref.length = len;
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (BigArrays.indexIsInt(index));
            System.arraycopy(buf, offset, this.array, (int)index, len);
        }
    }
}

