/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.ClusterStatePublishResponseHandler;

public class BlockingClusterStatePublishResponseHandler
implements ClusterStatePublishResponseHandler {
    private final CountDownLatch latch;

    public BlockingClusterStatePublishResponseHandler(int nonMasterNodes) {
        this.latch = new CountDownLatch(nonMasterNodes);
    }

    @Override
    public void onResponse(DiscoveryNode node) {
        this.latch.countDown();
    }

    @Override
    public void onFailure(DiscoveryNode node, Throwable t) {
        this.latch.countDown();
    }

    @Override
    public boolean awaitAllNodes(TimeValue timeout) throws InterruptedException {
        return this.latch.await(timeout.millis(), TimeUnit.MILLISECONDS);
    }
}

