/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.analysis.HunspellService;

@AnalysisSettingsRequired
public class HunspellTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final HunspellDictionary dictionary;
    private final boolean dedup;
    private final int recursionLevel;

    @Inject
    public HunspellTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings, HunspellService hunspellService) {
        super(index, indexSettings, name, settings);
        String locale = settings.get("locale", settings.get("language", settings.get("lang", null)));
        if (locale == null) {
            throw new ElasticsearchIllegalArgumentException("missing [locale | language | lang] configuration for hunspell token filter");
        }
        this.dictionary = hunspellService.getDictionary(locale);
        if (this.dictionary == null) {
            throw new ElasticsearchIllegalArgumentException(String.format(Locale.ROOT, "Unknown hunspell dictionary for locale [%s]", locale));
        }
        this.dedup = settings.getAsBoolean("dedup", (Boolean)true);
        this.recursionLevel = settings.getAsInt("recursion_level", (Integer)2);
        if (this.recursionLevel < 0) {
            throw new ElasticsearchIllegalArgumentException(String.format(Locale.ROOT, "Negative recursion level not allowed for hunspell [%d]", this.recursionLevel));
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, this.dedup, this.recursionLevel);
    }

    public boolean dedup() {
        return this.dedup;
    }

    public int recursionLevel() {
        return this.recursionLevel;
    }
}

