/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardIdCache
extends AbstractIndexShardComponent {
    final CounterMetric totalMetric = new CounterMetric();

    @Inject
    public ShardIdCache(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public IdCacheStats stats() {
        return new IdCacheStats(this.totalMetric.count());
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }
}

