/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigDoubleArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class GeoPointDoubleArrayIndexFieldData
extends AbstractGeoPointIndexFieldData {
    private final CircuitBreakerService breakerService;

    public GeoPointDoubleArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicGeoPointFieldData<ScriptDocValues> loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicGeoPointFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = new AbstractGeoPointIndexFieldData.Empty(reader.maxDoc());
            estimator.afterLoad(null, data.getMemorySizeInBytes());
            return data;
        }
        BigDoubleArrayList lat = new BigDoubleArrayList();
        BigDoubleArrayList lon = new BigDoubleArrayList();
        lat.add(0.0);
        lon.add(0.0);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(terms.size(), reader.maxDoc(), acceptableTransientOverheadRatio);
        boolean success = false;
        try {
            GeoPoint point;
            AbstractGeoPointIndexFieldData.GeoPointEnum iter = new AbstractGeoPointIndexFieldData.GeoPointEnum(builder.buildFromTerms(terms.iterator(null)));
            while ((point = iter.next()) != null) {
                lat.add(point.getLat());
                lon.add(point.getLon());
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                Ordinals.Docs ordinals = build.ordinals();
                int maxDoc = reader.maxDoc();
                BigDoubleArrayList sLat = new BigDoubleArrayList(reader.maxDoc());
                BigDoubleArrayList sLon = new BigDoubleArrayList(reader.maxDoc());
                for (int i = 0; i < maxDoc; ++i) {
                    long nativeOrdinal = ordinals.getOrd(i);
                    sLat.add(lat.get(nativeOrdinal));
                    sLon.add(lon.get(nativeOrdinal));
                }
                FixedBitSet set = builder.buildDocsWithValuesSet();
                data = set == null ? new GeoPointDoubleArrayAtomicFieldData.Single(sLon, sLat, reader.maxDoc(), ordinals.getNumOrds()) : new GeoPointDoubleArrayAtomicFieldData.SingleFixedSet(sLon, sLat, reader.maxDoc(), set, ordinals.getNumOrds());
            } else {
                data = new GeoPointDoubleArrayAtomicFieldData.WithOrdinals(lon, lat, reader.maxDoc(), build);
            }
            success = true;
            AtomicGeoPointFieldData atomicGeoPointFieldData = data;
            return atomicGeoPointFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.getMemorySizeInBytes());
            }
            builder.close();
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new GeoPointDoubleArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

