/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;

public class FieldMappersLookup
implements Iterable<FieldMapper> {
    private volatile ImmutableList<FieldMapper> mappers = ImmutableList.of();
    private volatile ImmutableOpenMap<String, FieldMappers> name;
    private volatile ImmutableOpenMap<String, FieldMappers> indexName;
    private volatile ImmutableOpenMap<String, FieldMappers> fullName = ImmutableOpenMap.of();

    public FieldMappersLookup() {
        this.name = ImmutableOpenMap.of();
        this.indexName = ImmutableOpenMap.of();
    }

    public void addNewMappers(Iterable<FieldMapper> newMappers) {
        ImmutableOpenMap.Builder<String, FieldMappers> tempName = ImmutableOpenMap.builder(this.name);
        ImmutableOpenMap.Builder<String, FieldMappers> tempIndexName = ImmutableOpenMap.builder(this.indexName);
        ImmutableOpenMap.Builder<String, FieldMappers> tempFullName = ImmutableOpenMap.builder(this.fullName);
        for (FieldMapper fieldMapper : newMappers) {
            FieldMappers mappers = tempName.get(fieldMapper.names().name());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempName.put(fieldMapper.names().name(), mappers);
            mappers = tempIndexName.get(fieldMapper.names().indexName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempIndexName.put(fieldMapper.names().indexName(), mappers);
            mappers = tempFullName.get(fieldMapper.names().fullName());
            mappers = mappers == null ? new FieldMappers(fieldMapper) : mappers.concat(fieldMapper);
            tempFullName.put(fieldMapper.names().fullName(), mappers);
        }
        this.mappers = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.mappers)).addAll(newMappers)).build();
        this.name = tempName.build();
        this.indexName = tempIndexName.build();
        this.fullName = tempFullName.build();
    }

    public void removeMappers(Iterable<FieldMapper> mappersToRemove) {
        ArrayList<FieldMapper> tempMappers = new ArrayList<FieldMapper>(this.mappers);
        ImmutableOpenMap.Builder<String, FieldMappers> tempName = ImmutableOpenMap.builder(this.name);
        ImmutableOpenMap.Builder<String, FieldMappers> tempIndexName = ImmutableOpenMap.builder(this.indexName);
        ImmutableOpenMap.Builder<String, FieldMappers> tempFullName = ImmutableOpenMap.builder(this.fullName);
        for (FieldMapper mapper : mappersToRemove) {
            FieldMappers mappers = tempName.get(mapper.names().name());
            if (mappers != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    tempName.remove(mapper.names().name());
                } else {
                    tempName.put(mapper.names().name(), mappers);
                }
            }
            if ((mappers = tempIndexName.get(mapper.names().indexName())) != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    tempIndexName.remove(mapper.names().indexName());
                } else {
                    tempIndexName.put(mapper.names().indexName(), mappers);
                }
            }
            if ((mappers = tempFullName.get(mapper.names().fullName())) != null) {
                if ((mappers = mappers.remove(mapper)).isEmpty()) {
                    tempFullName.remove(mapper.names().fullName());
                } else {
                    tempFullName.put(mapper.names().fullName(), mappers);
                }
            }
            tempMappers.remove(mapper);
        }
        this.mappers = ImmutableList.copyOf(tempMappers);
        this.name = tempName.build();
        this.indexName = tempIndexName.build();
        this.fullName = tempFullName.build();
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return this.mappers.iterator();
    }

    public ImmutableList<FieldMapper> mappers() {
        return this.mappers;
    }

    public boolean hasMapper(FieldMapper fieldMapper) {
        return this.mappers.contains(fieldMapper);
    }

    public FieldMappers name(String name) {
        return this.name.get(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.indexName.get(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fullName.get(fullName);
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        HashSet<String> fields = Sets.newHashSet();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().indexName());
        }
        return fields;
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = Sets.newHashSet();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().fullName());
        }
        return fields;
    }

    @Nullable
    public FieldMappers smartName(String name) {
        FieldMappers fieldMappers = this.fullName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        fieldMappers = this.indexName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        return this.name(name);
    }

    @Nullable
    public FieldMapper smartNameFieldMapper(String name) {
        FieldMappers fieldMappers = this.smartName(name);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }
}

